/*
 * Decompiled with CFR 0.152.
 */
package com.devjulen.spanishdelight.common.registry;

import com.devjulen.spanishdelight.common.block.GreenBeanCropBlock;
import com.devjulen.spanishdelight.common.registry.ModItemsRegistry;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.WildCropBlock;

public class ModBlocksRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"spanishdelight");
    public static final RegistryObject<Block> GREEN_BEAN_CROP = BLOCKS.register("green_bean_crop", () -> new GreenBeanCropBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50092_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> WILD_GARLIC = BLOCKS.register("wild_garlic", () -> new WildCropBlock(MobEffects.f_19598_, 5, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> WILD_RED_PEPPER = BLOCKS.register("wild_red_pepper", () -> new WildCropBlock(MobEffects.f_19596_, 8, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60955_().m_60910_()));
    public static final RegistryObject<Block> WILD_GREEN_PEPPER = BLOCKS.register("wild_green_pepper", () -> new WildCropBlock(MobEffects.f_19603_, 8, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50359_).m_60955_().m_60910_()));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject blockRegistry = BLOCKS.register(name, block);
        ModBlocksRegistry.registerBlockItem(name, blockRegistry);
        return blockRegistry;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItemsRegistry.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

