/*
 * Decompiled with CFR 0.152.
 */
package com.devjulen.spanishdelight.data;

import com.devjulen.spanishdelight.common.block.GreenBeanCropBlock;
import com.devjulen.spanishdelight.common.registry.ModBlocksRegistry;
import java.util.function.Function;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "spanishdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("spanishdelight", "block/" + path);
    }

    protected void registerStatesAndModels() {
        this.makeGreenBeanCrop((CropBlock)ModBlocksRegistry.GREEN_BEAN_CROP.get(), "green_bean_stage", "green_bean_stage");
        this.wildCropBlock((Block)ModBlocksRegistry.WILD_GARLIC.get());
        this.wildCropBlock((Block)ModBlocksRegistry.WILD_GREEN_PEPPER.get());
        this.wildCropBlock((Block)ModBlocksRegistry.WILD_RED_PEPPER.get());
    }

    public void wildCropBlock(Block block) {
        this.wildCropBlock(block, false);
    }

    public void wildCropBlock(Block block, boolean isBushCrop) {
        if (isBushCrop) {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().singleTexture(this.blockName(block), this.resourceBlock("bush_crop"), "crop", this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        } else {
            this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross(this.blockName(block), this.resourceBlock(this.blockName(block)))).renderType("cutout"));
        }
    }

    public void makeGreenBeanCrop(CropBlock block, String modelName, String textureName) {
        Function<BlockState, ConfiguredModel[]> function = state -> this.strawberryStates((BlockState)state, block, modelName, textureName);
        this.getVariantBuilder((Block)block).forAllStates(function);
    }

    private ConfiguredModel[] strawberryStates(BlockState state, CropBlock block, String modelName, String textureName) {
        ConfiguredModel[] models = new ConfiguredModel[]{new ConfiguredModel((ModelFile)((BlockModelBuilder)this.models().crop(modelName + state.m_61143_((Property)((GreenBeanCropBlock)block).m_7959_()), new ResourceLocation("spanishdelight", "block/" + textureName + state.m_61143_((Property)((GreenBeanCropBlock)block).m_7959_())))).renderType("cutout"))};
        return models;
    }
}

