/*
 * Decompiled with CFR 0.152.
 */
package com.devjulen.spanishdelight.data;

import com.devjulen.spanishdelight.data.BlockStates;
import com.devjulen.spanishdelight.data.BlockTags;
import com.devjulen.spanishdelight.data.GlobalLootModifiers;
import com.devjulen.spanishdelight.data.ItemModels;
import com.devjulen.spanishdelight.data.ItemTags;
import com.devjulen.spanishdelight.data.LootTables;
import com.devjulen.spanishdelight.data.Recipes;
import com.devjulen.spanishdelight.data.WorldGen;
import com.devjulen.spanishdelight.data.loot.SDBlockLootTables;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="spanishdelight", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookUpProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStates(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTables(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(SDBlockLootTables::new, LootContextParamSets.f_81421_))));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootModifiers(packOutput));
        BlockTags blockStates = (BlockTags)generator.addProvider(event.includeServer(), (DataProvider)new BlockTags(packOutput, lookUpProvider, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemTags(packOutput, lookUpProvider, blockStates.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new WorldGen(packOutput, lookUpProvider));
    }
}

