/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.delightful_slaughter.block;

import java.util.function.Supplier;
import net.akaciobahno.delightful_slaughter.block.custom.OrientableBlock;
import net.akaciobahno.delightful_slaughter.block.custom.RotatableCarpet;
import net.akaciobahno.delightful_slaughter.item.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"delightful_slaughter");
    public static final RegistryObject<Block> PANDA_BLOCK = ModBlocks.registerBlock("panda_block", () -> new OrientableBlock());
    public static final RegistryObject<Block> PANDA_CARPET = ModBlocks.registerBlock("panda_carpet", () -> new RotatableCarpet());
    public static final RegistryObject<Block> QUESTIONABLE_MINCED_MEAT = ModBlocks.registerBlock("questionable_minced_meat", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50374_).m_60967_(0.9f).m_60911_(0.9f).m_278166_(PushReaction.DESTROY).m_155954_(1.0f).m_60918_(SoundType.f_56750_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

