/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.huge;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.HugeDieselEngineBlockEntity;
import com.jesz.createdieselgenerators.content.diesel_engine.huge.PoweredEngineShaftBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MilkBucketItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class HugeDieselEngineBlock
extends Block
implements IBE<HugeDieselEngineBlockEntity>,
IWrenchable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public HugeDieselEngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        ItemStack stack = player.m_21120_(hand);
        for (EngineUpgrades upgrade : EngineUpgrades.allUpgrades) {
            if (upgrade == EngineUpgrades.EMPTY || !upgrade.getItem().m_150930_(stack.m_41720_())) continue;
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (!upgrade.canAddOn((IEngine)be)) {
                    return;
                }
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    return;
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                be.upgrade = upgrade;
                be.sendData();
                IWrenchable.playRotateSound((Level)level, (BlockPos)pos);
            });
            return InteractionResult.SUCCESS;
        }
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(stack)) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.m_41720_(), player, hand, hitResult);
        }
        if (!((Boolean)CDGConfig.ENGINES_FILLED_WITH_ITEMS.get()).booleanValue() || stack.m_41619_() || !((blockEntity = level.m_7702_(pos)) instanceof SmartBlockEntity)) {
            return InteractionResult.PASS;
        }
        SmartBlockEntity be2 = (SmartBlockEntity)blockEntity;
        IFluidHandler tank = (IFluidHandler)be2.getCapability(ForgeCapabilities.FLUID_HANDLER).orElse(null);
        if (tank == null) {
            return InteractionResult.PASS;
        }
        if (stack.m_41720_() instanceof BucketItem || stack.m_41720_() instanceof MilkBucketItem) {
            Fluid fluid;
            Item item = stack.m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bi = (BucketItem)item;
                v0 = bi.getFluid();
            } else {
                v0 = fluid = (Fluid)ForgeMod.MILK.get();
            }
            if (!tank.getFluidInTank(0).isEmpty()) {
                return InteractionResult.FAIL;
            }
            tank.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
            return InteractionResult.SUCCESS;
        }
        IFluidHandlerItem itemTank = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
        if (itemTank == null) {
            return InteractionResult.PASS;
        }
        itemTank.drain(tank.fill(itemTank.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        this.withBlockEntityDo((BlockGetter)context.m_43725_(), context.m_8083_(), be -> {
            if (be.upgrade != EngineUpgrades.EMPTY && !context.m_43725_().f_46443_) {
                if (!context.m_43723_().m_7500_()) {
                    context.m_43723_().m_150109_().m_150079_(be.upgrade.getItem());
                }
                be.upgrade = EngineUpgrades.EMPTY;
                be.sendData();
                IWrenchable.playRotateSound((Level)context.m_43725_(), (BlockPos)context.m_8083_());
            }
        });
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DieselEngineBlock.POWERED, FACING});
        super.m_7926_(builder);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos otherPos, boolean moving) {
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)DieselEngineBlock.POWERED, (Comparable)Boolean.valueOf(level.m_276867_(pos))));
        super.m_6861_(state, level, pos, block, otherPos, moving);
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredSide = null;
        for (Direction side : Iterate.directions) {
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            if (!(blockState.m_60734_() instanceof IRotate) || !((IRotate)blockState.m_60734_()).hasShaftTowards((LevelReader)context.m_43725_(), context.m_8083_().m_121945_(side), blockState, side.m_122424_())) continue;
            if (preferredSide != null && preferredSide.m_122434_() != side.m_122434_()) {
                preferredSide = null;
                break;
            }
            preferredSide = side;
        }
        return preferredSide;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (preferred == null || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            Direction nearestLookingDirection = context.m_7820_();
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(context.m_43723_() != null && context.m_43723_().m_6144_() ? nearestLookingDirection : nearestLookingDirection.m_122424_()));
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)preferred.m_122424_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockPos shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2);
        BlockState shaftState = level.m_8055_(shaftPos);
        if (shaftState.m_60734_() instanceof ShaftBlock && shaftState.m_61143_((Property)RotatedPillarKineticBlock.AXIS) != ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            level.m_7731_(shaftPos, PoweredEngineShaftBlock.getEquivalent(shaftState), 3);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos shaftPos;
        BlockState shaftState;
        if (!state.m_60713_(newState.m_60734_())) {
            this.withBlockEntityDo((BlockGetter)level, pos, be -> {
                if (be.upgrade != EngineUpgrades.EMPTY) {
                    HugeDieselEngineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)be.upgrade.getItem());
                }
            });
        }
        if (!(!state.m_155947_() || state.m_60713_(newState.m_60734_()) && newState.m_155947_())) {
            level.m_46747_(pos);
        }
        if (CDGBlocks.POWERED_ENGINE_SHAFT.has(shaftState = level.m_8055_(shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2)))) {
            level.m_186460_(shaftPos, shaftState.m_60734_(), 1);
        }
    }

    public Class<HugeDieselEngineBlockEntity> getBlockEntityClass() {
        return HugeDieselEngineBlockEntity.class;
    }

    public BlockEntityType<? extends HugeDieselEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.HUGE_DIESEL_ENGINE.get();
    }

    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.SHAFT).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof HugeDieselEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = pos.m_5484_((Direction)state.m_61143_((Property)FACING), 2);
            BlockState shaft = AllBlocks.SHAFT.getDefaultState();
            Direction[] directionArray = Direction.m_122382_((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && (shaft = (BlockState)shaft.m_61124_((Property)ShaftBlock.AXIS, (Comparable)(direction = directionArray[i]).m_122434_())).m_61143_((Property)RotatedPillarKineticBlock.AXIS) == ((Direction)state.m_61143_((Property)FACING)).m_122434_(); ++i) {
            }
            BlockState newState = level.m_8055_(shaftPos);
            if (!newState.m_247087_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.m_61143_((Property)ShaftBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)CDGBlocks.POWERED_ENGINE_SHAFT.getDefaultState()).m_61124_((Property)PoweredShaftBlock.AXIS, (Comparable)axis));
        }
    }
}

