/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.core;

import glitchcore.event.EventManager;
import glitchcore.util.Environment;
import glitchcore.util.RegistryHelper;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toughasnails.client.handler.KeyHandler;
import toughasnails.client.handler.LevelRenderHandler;
import toughasnails.client.handler.TooltipHandler;
import toughasnails.init.ModApi;
import toughasnails.init.ModBlockEntities;
import toughasnails.init.ModBlocks;
import toughasnails.init.ModClient;
import toughasnails.init.ModCompatibility;
import toughasnails.init.ModConfig;
import toughasnails.init.ModContainerTypes;
import toughasnails.init.ModCrafting;
import toughasnails.init.ModCreativeTab;
import toughasnails.init.ModEnchantments;
import toughasnails.init.ModItems;
import toughasnails.init.ModPackets;
import toughasnails.init.ModParticles;
import toughasnails.init.ModPotions;
import toughasnails.init.ModTags;
import toughasnails.init.ModVillages;
import toughasnails.temperature.TemperatureHandler;
import toughasnails.temperature.TemperatureOverlayRenderer;
import toughasnails.thirst.ThirstHandler;
import toughasnails.thirst.ThirstOverlayRenderer;

public class ToughAsNails {
    public static final String MOD_ID = "toughasnails";
    public static final Logger LOGGER = LogManager.getLogger((String)"toughasnails");

    public static void init() {
        ModConfig.init();
        ModTags.init();
        ToughAsNails.addRegistrars();
        ToughAsNails.addHandlers();
        ModPackets.init();
        ModApi.init();
        ModCompatibility.init();
    }

    public static void setupClient() {
        ModClient.setupRenderTypes();
    }

    public static void onServerAboutToStart(MinecraftServer server) {
        ModVillages.addBuildings((RegistryAccess)server.m_206579_());
    }

    private static void addRegistrars() {
        RegistryHelper regHelper = RegistryHelper.create();
        regHelper.addRegistrar(Registries.f_256747_, ModBlocks::registerBlocks);
        regHelper.addRegistrar(Registries.f_256913_, ModItems::registerItems);
        regHelper.addRegistrar(Registries.f_256798_, ModContainerTypes::registerContainers);
        regHelper.addRegistrar(Registries.f_256922_, ModBlockEntities::registerBlockEntities);
        regHelper.addRegistrar(Registries.f_256764_, ModCrafting::registerRecipeSerializers);
        regHelper.addRegistrar(Registries.f_256954_, ModCrafting::registerRecipeTypes);
        regHelper.addRegistrar(Registries.f_256762_, ModEnchantments::registerEnchantments);
        regHelper.addRegistrar(Registries.f_256929_, ModPotions::registerEffects);
        regHelper.addRegistrar(Registries.f_256973_, ModPotions::registerPotions);
        regHelper.addRegistrar(Registries.f_279569_, ModCreativeTab::registerCreativeTabs);
        regHelper.addRegistrar(Registries.f_256890_, ModParticles::registerParticles);
        regHelper.addRegistrar(Registries.f_256805_, ModVillages::registerPointsOfInterest);
        regHelper.addRegistrar(Registries.f_256749_, ModVillages::registerProfessions);
    }

    private static void addHandlers() {
        EventManager.addListener(TemperatureHandler::onChangeDimension);
        EventManager.addListener(TemperatureHandler::onItemUseFinish);
        EventManager.addListener(ThirstHandler::onChangeDimension);
        EventManager.addListener(ThirstHandler::onItemUseFinish);
        EventManager.addListener(ThirstHandler::onPlayerUseItem);
        EventManager.addListener(ThirstHandler::onUseBlock);
        EventManager.addListener(ModVillages::addVillagerTrades);
        EventManager.addListener(ModVillages::addWanderingVillagerTrades);
        if (Environment.isClient()) {
            ToughAsNails.addClientHandlers();
        }
    }

    private static void addClientHandlers() {
        EventManager.addListener(TemperatureOverlayRenderer::onClientTick);
        EventManager.addListener(TemperatureOverlayRenderer::onBeginRenderFood);
        EventManager.addListener(TemperatureOverlayRenderer::onBeginRenderFrostbite);
        EventManager.addListener(LevelRenderHandler::onLevelRender);
        EventManager.addListener(ThirstOverlayRenderer::onClientTick);
        EventManager.addListener(ThirstOverlayRenderer::onBeginRenderAir);
        EventManager.addListener(ThirstHandler::onUseEmpty);
        EventManager.addListener(ThirstHandler::onClientTick);
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::registerItemColors);
        EventManager.addListener(ModClient::registerParticleSprites);
        EventManager.addListener(TooltipHandler::onTooltip);
        EventManager.addListener(TooltipHandler::onRenderTooltip);
        EventManager.addListener(KeyHandler::onKeyPress);
    }
}

