/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.forge.datagen;

import java.util.Set;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import toughasnails.forge.datagen.ModDamageTypes;
import toughasnails.forge.datagen.loot.TANLootTableProvider;
import toughasnails.forge.datagen.provider.TANBiomeTagsProvider;
import toughasnails.forge.datagen.provider.TANBlockTagsProvider;
import toughasnails.forge.datagen.provider.TANDamageTypeTagsProvider;
import toughasnails.forge.datagen.provider.TANItemModelProvider;
import toughasnails.forge.datagen.provider.TANItemTagsProvider;
import toughasnails.forge.datagen.provider.TANPoiTypesTagsProvider;
import toughasnails.forge.datagen.provider.TANRecipeProvider;
import toughasnails.forge.datagen.provider.TANTrimMaterialTagsProvider;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="toughasnails")
public class DataGenerationHandler {
    private static final RegistrySetBuilder REG_BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_268580_, ModDamageTypes::bootstrap);

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        PackOutput output = generator.getPackOutput();
        DatapackBuiltinEntriesProvider datapackProvider = (DatapackBuiltinEntriesProvider)generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), REG_BUILDER, Set.of("toughasnails")));
        generator.addProvider(event.includeServer(), (DataProvider)new TANRecipeProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)TANLootTableProvider.create(output));
        TANBlockTagsProvider blocksTagProvider = (TANBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new TANBlockTagsProvider(output, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TANItemTagsProvider(output, datapackProvider.getRegistryProvider(), blocksTagProvider.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TANBiomeTagsProvider(output, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TANDamageTypeTagsProvider(output, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TANTrimMaterialTagsProvider(output, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TANPoiTypesTagsProvider(output, datapackProvider.getRegistryProvider(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new TANItemModelProvider(output, existingFileHelper));
    }
}

