/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toughasnails.api.player.ITANPlayer;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;
import toughasnails.temperature.TemperatureHandler;
import toughasnails.thirst.ThirstHandler;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayer
extends Player
implements ITANPlayer {
    public MixinServerPlayer(Level $$0, BlockPos $$1, float $$2, GameProfile $$3) {
        super($$0, $$1, $$2, $$3);
    }

    @Inject(method={"doTick"}, at={@At(value="TAIL")})
    public void onDoTick(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        ITemperature data = TemperatureHelper.getTemperatureData((Player)player);
        IThirst thirst = ThirstHelper.getThirst((Player)player);
        if (data.getLastLevel() != data.getLevel() || data.getLastHyperthermiaTicks() != data.getHyperthermiaTicks() || !data.getLastNearbyThermoregulators().equals(data.getNearbyThermoregulators())) {
            TemperatureHandler.syncTemperature(player);
        }
        if (thirst.getLastThirst() != thirst.getThirst() || thirst.getHydration() == 0.0f != thirst.getLastHydrationZero()) {
            ThirstHandler.syncThirst(player);
        }
    }

    @Inject(method={"restoreFrom"}, at={@At(value="TAIL")})
    public void onRestoreFrom(ServerPlayer player, boolean $$1, CallbackInfo ci) {
        if (!ModConfig.temperature.climateClemencyRespawning) {
            this.setClimateClemencyGranted(((ITANPlayer)player).getClimateClemencyGranted());
        }
    }
}

