/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network;

import glitchcore.network.CustomPacket;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import toughasnails.api.temperature.ITemperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.api.temperature.TemperatureLevel;

public class UpdateTemperaturePacket
implements CustomPacket<UpdateTemperaturePacket> {
    private TemperatureLevel temperatureLevel;
    private int hyperthermiaTicks;
    private Set<BlockPos> nearbyThermoregulators;

    public UpdateTemperaturePacket(TemperatureLevel temperatureLevel, int hyperthermiaTicks, Set<BlockPos> nearbyThermoregulators) {
        this.temperatureLevel = temperatureLevel;
        this.hyperthermiaTicks = hyperthermiaTicks;
        this.nearbyThermoregulators = nearbyThermoregulators;
    }

    public UpdateTemperaturePacket() {
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.temperatureLevel);
        buf.writeInt(this.hyperthermiaTicks);
        buf.m_236828_(this.nearbyThermoregulators, FriendlyByteBuf::m_130064_);
    }

    public UpdateTemperaturePacket decode(FriendlyByteBuf buf) {
        return new UpdateTemperaturePacket((TemperatureLevel)buf.m_130066_(TemperatureLevel.class), buf.readInt(), (Set)buf.m_236838_(HashSet::new, FriendlyByteBuf::m_130135_));
    }

    public void handle(UpdateTemperaturePacket packet, CustomPacket.Context context) {
        if (context.isServerSide()) {
            return;
        }
        context.getPlayer().ifPresent(player -> {
            ITemperature temperature = TemperatureHelper.getTemperatureData(player);
            temperature.setLevel(packet.temperatureLevel);
            temperature.setHyperthermiaTicks(packet.hyperthermiaTicks);
            temperature.setNearbyThermoregulators(packet.nearbyThermoregulators);
        });
    }
}

