/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import rbasamoyai.escalated.advancements.WalkwayTravelTracker;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayMovementHandler {
    public static boolean canBeTransported(Entity entity) {
        Player player;
        return entity.m_6084_() && (!(entity instanceof Player) || !(player = (Player)entity).m_6144_());
    }

    public static void transportEntity(WalkwayBlockEntity walkwayBE, Entity entity, TransportedEntityInfo info) {
        boolean movingUp;
        boolean movingDown;
        Vec3 movement;
        float movementSpeed;
        boolean isPlayer;
        Level level;
        block24: {
            Vec3 centering;
            block23: {
                double diffCenter;
                boolean betweenWalkways;
                BlockPos pos = info.lastCollidedPos;
                level = walkwayBE.m_58904_();
                BlockEntity otherBE = level.m_7702_(pos);
                BlockPos belowPos = BlockPos.m_274446_((Position)entity.m_20182_().m_82492_(0.0, 0.05, 0.0));
                BlockEntity beBelowPassenger = level.m_7702_(belowPos);
                BlockState blockState = info.lastCollidedState;
                WalkwayBlock walkwayBlock = (WalkwayBlock)blockState.m_60734_();
                Direction movementFacing = Direction.m_122387_((Direction.Axis)walkwayBlock.getFacing(blockState).m_122434_(), (Direction.AxisDirection)(walkwayBE.getSpeed() < 0.0f ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE));
                boolean collidedWithWalkways = otherBE instanceof WalkwayBlockEntity;
                boolean bl = betweenWalkways = beBelowPassenger instanceof WalkwayBlockEntity && beBelowPassenger != otherBE;
                if (!collidedWithWalkways || betweenWalkways) {
                    return;
                }
                if (Math.abs(walkwayBE.getSpeed()) < 1.0f || !walkwayBlock.movesEntities(blockState)) {
                    return;
                }
                if (entity.m_20186_() + 0.25 < (double)pos.m_123342_()) {
                    return;
                }
                isPlayer = entity instanceof Player;
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    if (!isPlayer) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 1, false, false));
                    }
                }
                Direction walkwayFacing = walkwayBlock.getFacing(blockState);
                WalkwaySlope slope = walkwayBlock.getWalkwaySlope(blockState);
                Direction.Axis axis = walkwayFacing.m_122434_();
                movementSpeed = walkwayBE.getWalkwayMovementSpeed();
                Direction movementDirection = Direction.m_122390_((Direction.AxisDirection)(axis == Direction.Axis.X ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE), (Direction.Axis)axis);
                Vec3i centeringDirection = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)walkwayFacing.m_122427_().m_122434_()).m_122436_();
                movement = Vec3.m_82528_((Vec3i)movementDirection.m_122436_()).m_82490_((double)movementSpeed);
                double d = diffCenter = axis == Direction.Axis.Z ? (double)((float)pos.m_123341_() + 0.5f) - entity.m_20185_() : (double)((float)pos.m_123343_() + 0.5f) - entity.m_20189_();
                if (Math.abs(diffCenter) > 0.75) {
                    return;
                }
                float top = 0.96875f;
                boolean onSlope = slope == WalkwaySlope.MIDDLE || slope == WalkwaySlope.TOP && entity.m_20186_() - (double)pos.m_123342_() < (double)top || slope == WalkwaySlope.BOTTOM && entity.m_20186_() - (double)pos.m_123342_() > (double)top;
                movingDown = onSlope && movementFacing != walkwayFacing;
                boolean bl2 = movingUp = onSlope && movementFacing == walkwayFacing;
                if (walkwayFacing.m_122434_() == Direction.Axis.Z) {
                    boolean b = movingDown;
                    movingDown = movingUp;
                    movingUp = b;
                }
                if (movingUp) {
                    movement = movement.m_82520_(0.0, Math.abs(axis.m_6150_(movement.f_82479_, movement.f_82480_, movement.f_82481_)), 0.0);
                }
                if (movingDown) {
                    movement = movement.m_82520_(0.0, -Math.abs(axis.m_6150_(movement.f_82479_, movement.f_82480_, movement.f_82481_)), 0.0);
                }
                centering = Vec3.m_82528_((Vec3i)centeringDirection).m_82490_(diffCenter * (double)Math.min(Math.abs(movementSpeed), 0.1f) * 4.0);
                if (!(entity instanceof LivingEntity)) break block23;
                LivingEntity living = (LivingEntity)entity;
                if (living.f_20902_ != 0.0f || living.f_20900_ != 0.0f) break block24;
            }
            movement = movement.m_82549_(centering);
        }
        float step = entity.m_274421_();
        if (!isPlayer) {
            entity.m_274367_(1.0f);
        }
        if (Math.abs(movementSpeed) < 0.5f) {
            Vec3 checkDistance = movement.m_82541_().m_82490_(0.5);
            AABB bb = entity.m_20191_();
            AABB checkBB = new AABB(bb.f_82288_, bb.f_82289_, bb.f_82290_, bb.f_82291_, bb.f_82292_, bb.f_82293_);
            checkBB = checkBB.m_82383_(checkDistance).m_82377_(-Math.abs(checkDistance.f_82479_), -Math.abs(checkDistance.f_82480_), -Math.abs(checkDistance.f_82481_));
            List list = level.m_45933_(entity, checkBB);
            list.removeIf(e -> WalkwayMovementHandler.shouldIgnoreBlocking(entity, e));
            if (!list.isEmpty()) {
                entity.m_20334_(0.0, 0.0, 0.0);
                --info.ticksSinceLastCollision;
                return;
            }
        }
        entity.f_19789_ = 0.0f;
        if (movingUp) {
            Vec3 prevPos = entity.m_20182_();
            entity.m_6478_(MoverType.SELF, movement);
            if (entity.f_19862_) {
                entity.m_146884_(prevPos);
                entity.m_6478_(MoverType.SELF, new Vec3(0.0, movement.f_82480_ * 0.1, 0.0));
                entity.m_6478_(MoverType.SELF, movement);
            }
        } else if (movingDown) {
            entity.m_6478_(MoverType.SELF, movement.m_82542_(1.0, 0.0, 1.0));
            entity.m_6478_(MoverType.SELF, movement.m_82542_(0.0, 1.0, 0.0));
        } else {
            entity.m_6478_(MoverType.SELF, movement);
        }
        entity.m_6853_(true);
        if (isPlayer && !entity.m_9236_().f_46443_) {
            WalkwayTravelTracker.trackPlayerOnWalkway((Player)entity, 300);
        } else {
            entity.m_274367_(step);
        }
    }

    public static boolean shouldIgnoreBlocking(Entity me, Entity other) {
        if (other instanceof HangingEntity) {
            return true;
        }
        if (other.m_7752_() == PushReaction.IGNORE) {
            return true;
        }
        return WalkwayMovementHandler.isRidingOrBeingRiddenBy(me, other);
    }

    public static boolean isRidingOrBeingRiddenBy(Entity me, Entity other) {
        for (Entity entity : me.m_20197_()) {
            if (entity.equals((Object)other)) {
                return true;
            }
            if (!WalkwayMovementHandler.isRidingOrBeingRiddenBy(entity, other)) continue;
            return true;
        }
        return false;
    }

    public static class TransportedEntityInfo {
        int ticksSinceLastCollision;
        BlockPos lastCollidedPos;
        BlockState lastCollidedState;

        public TransportedEntityInfo(BlockPos collision, BlockState walkway) {
            this.refresh(collision, walkway);
        }

        public void refresh(BlockPos collision, BlockState walkway) {
            this.ticksSinceLastCollision = 0;
            this.lastCollidedPos = new BlockPos((Vec3i)collision).m_7949_();
            this.lastCollidedState = walkway;
        }

        public TransportedEntityInfo tick() {
            ++this.ticksSinceLastCollision;
            return this;
        }

        public int getTicksSinceLastCollision() {
            return this.ticksSinceLastCollision;
        }
    }
}

