/*
 * Decompiled with CFR 0.152.
 */
package umpaz.nethersdelight.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import umpaz.nethersdelight.common.block.entity.AbstractStoveBlockEntity;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.utility.MathUtils;

public abstract class AbstractStoveBlock
extends BaseEntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public AbstractStoveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Boolean)state.m_61143_((Property)LIT) != false ? this.tryToExtinguish(state, level, pos, player, hand, hit) : this.tryToIgnite(state, level, pos, player, hand, hit)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        if (this.tryToPlaceFoodItem(state, level, pos, player, hand, hit)) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean tryToIgnite(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (heldStack.canPerformAction(ToolActions.SHOVEL_DIG)) {
            this.extinguish((Entity)player, state, level, pos);
            heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
            return true;
        }
        if (heldItem == Items.f_42447_) {
            if (!level.m_5776_()) {
                level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.extinguish((Entity)player, state, level, pos);
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42446_));
            }
            return true;
        }
        return false;
    }

    protected boolean tryToExtinguish(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        Item heldItem = heldStack.m_41720_();
        if (heldItem instanceof FlintAndSteelItem) {
            level.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, MathUtils.RAND.nextFloat() * 0.4f + 0.8f);
            this.ignite(state, level, pos);
            heldStack.m_41622_(1, (LivingEntity)player, action -> action.m_21190_(hand));
            return true;
        }
        if (heldItem instanceof FireChargeItem) {
            if (!level.f_46443_) {
                level.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, (MathUtils.RAND.nextFloat() - MathUtils.RAND.nextFloat()) * 0.2f + 1.0f);
            }
            this.ignite(state, level, pos);
            if (!player.m_150110_().f_35937_) {
                heldStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    protected boolean tryToPlaceFoodItem(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof AbstractStoveBlockEntity)) {
            return false;
        }
        AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)blockEntity;
        ItemStack itemstack = player.m_21120_(hand);
        Optional recipe = stoveBlockEntity.getCookableRecipe(itemstack);
        if (recipe.isEmpty()) {
            return false;
        }
        if (level.m_5776_()) {
            return true;
        }
        return stoveBlockEntity.placeFood((Entity)player, player.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, ((AbstractCookingRecipe)recipe.get()).m_43753_());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true));
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)level.m_8055_(pos).m_61143_((Property)LIT);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)((LivingEntity)entity))) {
            entity.m_6469_(ModDamageTypes.getSimpleDamageSource((Level)level, (ResourceKey)ModDamageTypes.STOVE_BURN), 1.0f);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof AbstractStoveBlockEntity) {
            AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)tileEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, stoveBlockEntity.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState p_48722_, Rotation rotation) {
        return (BlockState)p_48722_.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)p_48722_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.m_7926_(stateBuilder);
        stateBuilder.m_61104_(new Property[]{FACING, LIT});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource randomSource) {
        if (((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.5;
            if (randomSource.m_188503_(10) == 0) {
                level.m_7785_(x, y, z, (SoundEvent)ModSounds.BLOCK_STOVE_CRACKLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
            Direction.Axis direction$axis = direction.m_122434_();
            double horizontalOffset = randomSource.m_188500_() * 0.6 - 0.3;
            double xOffset = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : horizontalOffset;
            double yOffset = randomSource.m_188500_() * 6.0 / 16.0;
            double zOffset = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : horizontalOffset;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + xOffset, y + yOffset, z + zOffset, 0.0, 0.0, 0.0);
        }
    }

    public void extinguish(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
        double x = (double)pos.m_123341_() + 0.5;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7785_(x, y, z, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f, false);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof AbstractStoveBlockEntity) {
            AbstractStoveBlockEntity stoveBlockEntity = (AbstractStoveBlockEntity)blockentity;
            stoveBlockEntity.extinguish();
        }
        level.m_142346_(entity, GameEvent.f_157792_, pos);
    }

    public void ignite(BlockState state, Level level, BlockPos pos) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)), 11);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStoveTicker(Level level, BlockState state, BlockEntityType<T> tickerBlockEntityType, BlockEntityType<? extends AbstractStoveBlockEntity<?, ?>> thisBlockEntityType) {
        if (level.f_46443_) {
            return AbstractStoveBlock.m_152132_(tickerBlockEntityType, thisBlockEntityType, AbstractStoveBlockEntity::particleTick);
        }
        return AbstractStoveBlock.m_152132_(tickerBlockEntityType, thisBlockEntityType, (BlockEntityTicker)((Boolean)state.m_61143_((Property)LIT) != false ? AbstractStoveBlockEntity::cookTick : AbstractStoveBlockEntity::cooldownTick));
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return (Boolean)state.m_61143_((Property)LIT) != false ? BlockPathTypes.DAMAGE_FIRE : null;
    }
}

