/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModTags;
import sereneseasons.util.SeasonColorUtil;

public class SeasonColorHandlers {
    private static final Multimap<ResolverType, ColorOverride> resolverOverrides = HashMultimap.create();
    private static ColorResolver originalGrassColorResolver;
    private static ColorResolver originalFoliageColorResolver;

    public static void setup() {
        SeasonColorHandlers.registerGrassAndFoliageColorHandlers();
    }

    public static void registerResolverOverride(ResolverType type, ColorOverride override) {
        resolverOverrides.put((Object)type, (Object)override);
    }

    private static void registerGrassAndFoliageColorHandlers() {
        originalGrassColorResolver = BiomeColors.f_108789_;
        originalFoliageColorResolver = BiomeColors.f_108790_;
        BiomeColors.f_108789_ = (biome, x, z) -> SeasonColorHandlers.resolveColors(ResolverType.GRASS, biome, x, z);
        BiomeColors.f_108790_ = (biome, x, z) -> SeasonColorHandlers.resolveColors(ResolverType.FOLIAGE, biome, x, z);
    }

    private static int resolveColors(ResolverType type, Biome biome, double x, double z) {
        int originalColor = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ResolverType.GRASS -> originalGrassColorResolver.m_130045_(biome, x, z);
            case ResolverType.FOLIAGE -> originalFoliageColorResolver.m_130045_(biome, x, z);
        };
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return originalColor;
        }
        Registry biomeRegistry = level.m_9598_().m_175515_(Registries.f_256952_);
        Holder biomeHolder = biomeRegistry.m_7854_((Object)biome).flatMap(arg_0 -> ((Registry)biomeRegistry).m_203636_(arg_0)).orElse(null);
        if (biomeHolder != null) {
            int seasonalColor;
            ISeasonState calendar = SeasonHelper.getSeasonState((Level)level);
            Enum colorProvider = biomeHolder.m_203656_(ModTags.Biomes.TROPICAL_BIOMES) ? calendar.getTropicalSeason() : calendar.getSubSeason();
            int currentColor = seasonalColor = (switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case ResolverType.GRASS -> SeasonColorUtil.applySeasonalGrassColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
                case ResolverType.FOLIAGE -> SeasonColorUtil.applySeasonalFoliageColouring(colorProvider, (Holder<Biome>)biomeHolder, originalColor);
            });
            for (ColorOverride override : resolverOverrides.get((Object)type)) {
                currentColor = override.apply(originalColor, seasonalColor, currentColor, (Holder<Biome>)biomeHolder, x, z);
            }
            return currentColor;
        }
        return originalColor;
    }

    public static enum ResolverType {
        GRASS,
        FOLIAGE;

    }

    public static interface ColorOverride {
        public int apply(int var1, int var2, int var3, Holder<Biome> var4, double var5, double var7);
    }
}

