/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.pojo.data.recipe.TableRecipe;
import java.util.ArrayList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;

public class GunSmithTableSerializer
implements RecipeSerializer<GunSmithTableRecipe> {
    @Nullable
    public GunSmithTableRecipe fromJson(ResourceLocation id, JsonObject jsonObject) {
        TableRecipe tableRecipe = (TableRecipe)CommonAssetsManager.GSON.fromJson((JsonElement)jsonObject, TableRecipe.class);
        if (tableRecipe != null) {
            return new GunSmithTableRecipe(id, tableRecipe);
        }
        return null;
    }

    @Nullable
    public GunSmithTableRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<GunSmithTableIngredient> ingredients = new ArrayList<GunSmithTableIngredient>();
        for (int i = 0; i < size; ++i) {
            ingredients.add(new GunSmithTableIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.readInt()));
        }
        ItemStack resultItem = buffer.m_130267_();
        ResourceLocation group = buffer.m_130281_();
        GunSmithTableResult result = new GunSmithTableResult(resultItem, group);
        return new GunSmithTableRecipe(recipeId, result, ingredients);
    }

    public void toNetwork(FriendlyByteBuf buffer, GunSmithTableRecipe recipe) {
        buffer.writeInt(recipe.getInputs().size());
        for (GunSmithTableIngredient ingredient : recipe.getInputs()) {
            ingredient.getIngredient().m_43923_(buffer);
            buffer.writeInt(ingredient.getCount());
        }
        buffer.m_130055_(recipe.getResult().getResult());
        buffer.m_130085_(recipe.getResult().getGroup());
    }
}

