/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.equipment.armor.BacktankBlockEntity;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.tom.createores.OreDataCapability;
import com.tom.createores.Registration;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import com.tom.createores.util.TooltipUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SampleDrillBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IHaveHoveringInformation,
IDrill {
    public static final int DRILL_TIME = 200;
    private ResourceLocation veinClient;
    private long resourceRemClient;
    private VeinRecipe vein;
    private OreDataCapability.OreData data;
    private int progress = 0;
    private boolean drilling = false;
    private float airTankLevel = -1.0f;

    public SampleDrillBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VeinRecipe veinR = this.veinClient != null ? (VeinRecipe)this.f_58857_.m_7465_().m_44043_(this.veinClient).filter(e -> e instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null) : null;
        Component vein = veinR != null ? veinR.getName() : Component.m_237115_((String)"chat.coe.veinFinder.nothing");
        TooltipUtil.forGoggles(tooltip, Component.m_237110_((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein}));
        if (!this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60838_((BlockGetter)this.f_58857_, this.f_58858_.m_7495_())) {
            TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.drill.noGround"));
        }
        if (this.drilling) {
            if (this.progress < 200) {
                TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.drill.progress").m_130946_(": [").m_7220_(ClientUtil.makeProgressBar((float)this.progress / 200.0f)).m_130946_("]"));
            } else {
                TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.sample_drill.done"));
            }
        } else if (this.airTankLevel > 0.2f) {
            TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.sample_drill.click_to_start"));
        }
        if (this.resourceRemClient != 0L) {
            TooltipUtil.forGoggles(tooltip, Component.m_237110_((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)}));
        }
        if (this.airTankLevel < 0.0f) {
            TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.sample_drill.no_air"));
        } else if (this.airTankLevel < 0.21f) {
            TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.sample_drill.low_air"));
        } else {
            TooltipUtil.forGoggles(tooltip, Component.m_237115_((String)"info.coe.sample_drill.air").m_130946_(": [").m_7220_(ClientUtil.makeProgressBar(this.airTankLevel)).m_130946_("]"));
        }
        return true;
    }

    private void updateVein() {
        ChunkPos p = new ChunkPos(this.f_58858_);
        this.data = OreDataCapability.getData(this.f_58857_.m_6325_(p.f_45578_, p.f_45579_));
        RecipeManager m = this.f_58857_.m_7465_();
        if (this.data != null) {
            this.vein = this.data.getRecipe(m);
        }
    }

    public void tick() {
        BlockEntity be;
        super.tick();
        if (!this.f_58857_.f_46443_ && this.drilling && this.progress < 200 && this.f_58857_.m_8055_(this.f_58858_.m_7495_()).m_60838_((BlockGetter)this.f_58857_, this.f_58858_.m_7495_()) && (be = this.f_58857_.m_7702_(this.f_58858_.m_7494_())) instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            int air = t.getAirLevel();
            if (t.getComparatorOutput() > ComparatorUtil.fractionToRedstoneLevel((double)0.2f)) {
                int op = Mth.m_14045_((int)(air / 80), (int)1, (int)4);
                t.setAirLevel(air - op);
                this.progress += op;
                this.notifyUpdate();
            }
        }
    }

    public void lazyTick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateVein();
        BlockEntity be = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        if (be instanceof BacktankBlockEntity) {
            BacktankBlockEntity t = (BacktankBlockEntity)be;
            this.airTankLevel = (float)t.getComparatorOutput() / (float)ComparatorUtil.fractionToRedstoneLevel((double)1.0);
        } else {
            this.airTankLevel = -1.0f;
        }
        this.notifyUpdate();
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128405_("progress", this.progress);
        compound.m_128379_("drilling", this.drilling);
        if (clientPacket) {
            if (this.vein != null) {
                compound.m_128359_("veinId", this.vein.m_6423_().toString());
                compound.m_128356_("resRem", this.data.getResourcesRemaining(this.vein));
            }
            compound.m_128350_("air", this.airTankLevel);
        }
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.progress = compound.m_128451_("progress");
        this.drilling = compound.m_128471_("drilling");
        if (clientPacket) {
            if (compound.m_128441_("veinId")) {
                this.veinClient = new ResourceLocation(compound.m_128461_("veinId"));
                this.resourceRemClient = compound.m_128454_("resRem");
            } else {
                this.veinClient = null;
            }
            this.airTankLevel = compound.m_128457_("air");
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void clicked(Player player) {
        if (this.progress >= 200) {
            if (this.vein == null) {
                player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.found", (Object[])new Object[]{Component.m_237115_((String)"chat.coe.veinFinder.nothing")}), true);
            } else {
                ItemStack is = player.m_21205_();
                if (is.m_41720_() == Registration.VEIN_ATLAS_ITEM.get()) {
                    ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).addVein(player, is, this.vein, new DimChunkPos(this.f_58857_, this.f_58858_), this.data.getRandomMul());
                    return;
                }
                player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.noAtlas"), true);
            }
        } else if (!this.drilling) {
            if (this.airTankLevel > 0.2f) {
                this.progress = 0;
                this.drilling = true;
                player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.start"), true);
            } else if (this.airTankLevel < 0.0f) {
                player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.noAir"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.lowAir"), true);
            }
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.running"), true);
        }
    }

    @Override
    public ItemStack getDrill() {
        return Registration.NORMAL_DRILL_ITEM.asStack();
    }

    @Override
    public BlockPos getBelow() {
        return this.f_58858_.m_7495_();
    }

    @Override
    public Direction getFacing() {
        return Direction.SOUTH;
    }

    @Override
    public boolean shouldRenderRubble() {
        return this.progress > 0;
    }

    @Override
    public float getYOffset() {
        return 1.7f;
    }

    @Override
    public float getDrillOffset() {
        return this.progress >= 200 ? 0.0f : (float)this.progress / 200.0f * 0.5f;
    }

    @Override
    public float getRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.m_58904_().m_46467_();
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public float getPrevRotation() {
        if (this.progress >= 200) {
            return 0.0f;
        }
        if (this.progress > 0 && this.airTankLevel > 0.2f) {
            long ticks = this.m_58904_().m_46467_() - 1L;
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderShaft() {
        return (float)this.progress / 200.0f > 0.5f && this.progress < 200;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public void setAirTankLevel(float airTankLevel) {
        this.airTankLevel = airTankLevel;
    }
}

