/*
 * Decompiled with CFR 0.152.
 */
package org.domi.entityDrops;

import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class EntityDropUtil {
    private static final Random RANDOM = new Random();

    public static boolean entityDrop(LivingDropsEvent event, String entityId, RegistryObject<Item> dropItem, int minAmount, int addAmount, float chance) {
        LivingEntity entity = event.getEntity();
        ResourceLocation entityResLoc = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        ResourceLocation targetEntityId = new ResourceLocation(entityId);
        if (entityResLoc != null && entityResLoc.equals((Object)targetEntityId) && RANDOM.nextFloat() <= chance) {
            int amount = minAmount;
            if (addAmount > 0) {
                amount += RANDOM.nextInt(addAmount + 1);
            }
            ItemStack stack = new ItemStack((ItemLike)dropItem.get(), amount);
            ItemEntity itemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
            event.getDrops().add(itemEntity);
            return true;
        }
        return false;
    }

    public static boolean entityDrop(LivingDropsEvent event, String entityId, RegistryObject<Item> dropItem, int minAmount, int addAmount) {
        return EntityDropUtil.entityDrop(event, entityId, dropItem, minAmount, addAmount, 1.0f);
    }

    public static boolean entityDrops(LivingDropsEvent event, String entityId, RegistryObject<Item>[] dropItems, int[] minAmounts, int[] addAmounts, float[] chances) {
        LivingEntity entity = event.getEntity();
        ResourceLocation entityResLoc = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        ResourceLocation targetEntityId = new ResourceLocation(entityId);
        if (entityResLoc != null && entityResLoc.equals((Object)targetEntityId)) {
            boolean anyDropped = false;
            for (int i = 0; i < dropItems.length; ++i) {
                if (!(RANDOM.nextFloat() <= chances[i])) continue;
                int amount = minAmounts[i];
                if (addAmounts[i] > 0) {
                    amount += RANDOM.nextInt(addAmounts[i] + 1);
                }
                ItemStack stack = new ItemStack((ItemLike)dropItems[i].get(), amount);
                ItemEntity itemEntity = new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack);
                event.getDrops().add(itemEntity);
                anyDropped = true;
            }
            return anyDropped;
        }
        return false;
    }

    public static boolean entityDrops(LivingDropsEvent event, String entityId, RegistryObject<Item>[] dropItems, int[] minAmounts, int[] addAmounts) {
        float[] chances = new float[dropItems.length];
        for (int i = 0; i < chances.length; ++i) {
            chances[i] = 1.0f;
        }
        return EntityDropUtil.entityDrops(event, entityId, dropItems, minAmounts, addAmounts, chances);
    }
}

