/*
 * Decompiled with CFR 0.152.
 */
package org.domi.init;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.domi.init.block.PMFBlock;

public class PMFConsumableBlock
extends PMFBlock {
    public static final IntegerProperty BITES = IntegerProperty.m_61631_((String)"bites", (int)0, (int)4);
    private final Supplier<Item> clickItem;
    private final Supplier<Item> returnItem;
    private final boolean dropBlockWhenFull;
    protected static final VoxelShape SHAPE_FULL = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_BITE_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_BITE_2 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SHAPE_BITE_3 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    protected static final VoxelShape SHAPE_BITE_4 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);

    public PMFConsumableBlock(BlockBehaviour.Properties properties, Supplier<Item> returnItem, Supplier<Item> clickItem, boolean dropBlockWhenFull) {
        super(properties);
        this.returnItem = returnItem;
        this.clickItem = clickItem;
        this.dropBlockWhenFull = dropBlockWhenFull;
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        switch (bites) {
            case 0: {
                return SHAPE_FULL;
            }
            case 1: {
                return SHAPE_BITE_1;
            }
            case 2: {
                return SHAPE_BITE_2;
            }
            case 3: {
                return SHAPE_BITE_3;
            }
            case 4: {
                return SHAPE_BITE_4;
            }
        }
        return SHAPE_FULL;
    }

    public static RegistryObject<Block> registerConsumableBlock(String name, BlockBehaviour.Properties properties, Supplier<Item> returnItem, Supplier<Item> clickItem, boolean dropBlockWhenFull) {
        return PMFBlock.BLOCKS.register(name, () -> new PMFConsumableBlock(properties, returnItem, clickItem, dropBlockWhenFull));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BITES});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        int bites;
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == this.clickItem.get() && (bites = ((Integer)state.m_61143_((Property)BITES)).intValue()) < 4) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (!level.m_5776_()) {
                ItemStack returnStack = new ItemStack((ItemLike)this.returnItem.get());
                if (!player.m_150109_().m_36054_(returnStack)) {
                    player.m_36176_(returnStack, false);
                }
                level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)BITES);
        if (bites == 0 && this.dropBlockWhenFull && !level.f_46443_ && !player.m_150110_().f_35937_) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            PMFConsumableBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)itemstack);
        }
        super.m_5707_(level, pos, state, player);
    }
}

