/*
 * Decompiled with CFR 0.152.
 */
package org.domi.init.items;

import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;
import org.domi.init.items.PMFItem;

public class PMFFoodItem
extends PMFItem {
    private final boolean isTeleporting;

    public PMFFoodItem(Item.Properties properties, boolean isTeleporting) {
        super(properties);
        this.isTeleporting = isTeleporting;
    }

    public PMFFoodItem(Item.Properties properties) {
        this(properties, false);
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (this.isTeleporting && entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_) {
                this.teleport(player);
            }
        }
        return super.m_5922_(stack, world, entity);
    }

    private void teleport(Player player) {
        Random random = new Random();
        for (int i = 0; i < 32; ++i) {
            double z;
            double y;
            double x = player.m_20185_() + (random.nextDouble() - 0.5) * 20.0;
            if (!player.m_20984_(x, y = player.m_20186_() + (double)(random.nextInt(21) - 10), z = player.m_20189_() + (random.nextDouble() - 0.5) * 20.0, true)) continue;
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }

    public static RegistryObject<Item> registerFood(String name, int hunger, float saturation) {
        return ITEMS.register(name, () -> new PMFFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38767_())));
    }

    public static RegistryObject<Item> registerTeleportingFood(String name, int hunger, float saturation) {
        return ITEMS.register(name, () -> new PMFFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38767_()), true));
    }

    public static RegistryObject<Item> registerFoodWithEffect(String name, int hunger, float saturation, MobEffectInstance effect, float probability) {
        return ITEMS.register(name, () -> new PMFFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38762_(effect, probability).m_38767_())));
    }

    public static RegistryObject<Item> registerFoodWithMultipleEffects(String name, int hunger, float saturation, MobEffectInstance ... effects) {
        FoodProperties.Builder foodBuilder = new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation);
        for (MobEffectInstance effect : effects) {
            foodBuilder.m_38762_(effect, 1.0f);
        }
        return ITEMS.register(name, () -> new PMFFoodItem(new Item.Properties().m_41489_(foodBuilder.m_38767_())));
    }

    protected static RegistryObject<Item> registerFastFood(String name, int hunger, float saturation) {
        return ITEMS.register(name, () -> new PMFFoodItem(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(hunger).m_38758_(saturation).m_38766_().m_38767_())));
    }
}

