/*
 * Decompiled with CFR 0.152.
 */
package org.domi.init.recipes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class PMFCookingRecipeBuilder {
    private static final List<CookingRecipe> RECIPES = new ArrayList<CookingRecipe>();

    public static void registerSmeltingRecipe(ItemLike ingredient, ItemLike result, float experience, int smeltingTime) {
        RECIPES.add(new CookingRecipe(ingredient, result, experience, smeltingTime, false, 0, 0, 0, false, null, 0, false, null, null, ingredient));
    }

    public static void registerAllCookingRecipe(ItemLike ingredient, ItemLike result, float experience, int smeltingTime) {
        RECIPES.add(new CookingRecipe(ingredient, result, experience, smeltingTime, true, smeltingTime * 3, smeltingTime / 2, smeltingTime / 2, false, null, 0, false, null, null, ingredient));
    }

    public static void registerAllCookingRecipe(ItemLike ingredient, ItemLike result, float experience, int smeltingTime, int campfireTime, int smokingTime, int blastingTime) {
        RECIPES.add(new CookingRecipe(ingredient, result, experience, smeltingTime, true, campfireTime, smokingTime, blastingTime, false, null, 0, false, null, null, ingredient));
    }

    public static void registerShapelessRecipe(ItemLike result, int count, List<ItemLike> ingredients, ItemLike unlockItem) {
        RECIPES.add(new CookingRecipe(null, result, 0.0f, 0, false, 0, 0, 0, true, new ArrayList<ItemLike>(ingredients), count, false, null, null, unlockItem));
    }

    public static void registerShapedRecipe(ItemLike result, int count, List<String> pattern, Map<Character, ItemLike> keys, ItemLike unlockItem) {
        RECIPES.add(new CookingRecipe(null, result, 0.0f, 0, false, 0, 0, 0, false, null, count, true, new ArrayList<String>(pattern), keys, unlockItem));
    }

    public static void buildAllRecipes(Consumer<FinishedRecipe> consumer) {
        for (CookingRecipe recipe : RECIPES) {
            if (recipe.isShapeless) {
                PMFCookingRecipeBuilder.createShapelessRecipe(consumer, recipe.result, recipe.count, recipe.shapelessIngredients, recipe.unlockItem);
                continue;
            }
            if (recipe.isShaped) {
                PMFCookingRecipeBuilder.createShapedRecipe(consumer, recipe.result, recipe.count, recipe.pattern, recipe.keys, recipe.unlockItem);
                continue;
            }
            if (recipe.createAllTypes) {
                PMFCookingRecipeBuilder.createAllCookingRecipes(consumer, recipe.ingredient, recipe.result, recipe.experience, recipe.smeltingTime, recipe.campfireTime, recipe.smokingTime, recipe.blastingTime);
                continue;
            }
            PMFCookingRecipeBuilder.createSmeltingRecipe(consumer, recipe.ingredient, recipe.result, recipe.experience, recipe.smeltingTime);
        }
    }

    public static void createSmeltingRecipe(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_126140_(consumer, new ResourceLocation("carnivore", resultId + "_from_smelting"));
    }

    public static void createCampfireRecipe(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_126140_(consumer, new ResourceLocation("carnivore", resultId + "_from_campfire"));
    }

    public static void createSmokingRecipe(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_126140_(consumer, new ResourceLocation("carnivore", resultId + "_from_smoking"));
    }

    public static void createBlastingRecipe(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int cookingTime) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)result, (float)experience, (int)cookingTime).m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingredient})).m_126140_(consumer, new ResourceLocation("carnivore", resultId + "_from_blasting"));
    }

    public static void createAllCookingRecipes(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int smeltingTime, int campfireTime, int smokingTime, int blastingTime) {
        PMFCookingRecipeBuilder.createSmeltingRecipe(consumer, ingredient, result, experience, smeltingTime);
        PMFCookingRecipeBuilder.createCampfireRecipe(consumer, ingredient, result, experience, campfireTime);
        PMFCookingRecipeBuilder.createSmokingRecipe(consumer, ingredient, result, experience, smokingTime);
    }

    public static void createAllCookingRecipes(Consumer<FinishedRecipe> consumer, ItemLike ingredient, ItemLike result, float experience, int smeltingTime) {
        int campfireTime = smeltingTime * 3;
        int smokingTime = smeltingTime / 2;
        int blastingTime = smeltingTime / 2;
        PMFCookingRecipeBuilder.createAllCookingRecipes(consumer, ingredient, result, experience, smeltingTime, campfireTime, smokingTime, blastingTime);
    }

    public static void createShapedRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, int count, List<String> pattern, Map<Character, ItemLike> keys, ItemLike criterionItem) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count);
        for (String string : pattern) {
            builder.m_126130_(string);
        }
        for (Map.Entry entry : keys.entrySet()) {
            builder.m_126127_((Character)entry.getKey(), (ItemLike)entry.getValue());
        }
        builder.m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{criterionItem})).m_126140_(consumer, new ResourceLocation("carnivore", resultId));
    }

    public static void createShapelessRecipe(Consumer<FinishedRecipe> consumer, ItemLike result, int count, List<ItemLike> ingredients, ItemLike criterionItem) {
        String resultId = ForgeRegistries.ITEMS.getKey((Object)result.m_5456_()).m_135815_();
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)result, (int)count);
        for (ItemLike ingredient : ingredients) {
            builder.m_126209_(ingredient);
        }
        builder.m_126132_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{criterionItem})).m_126140_(consumer, new ResourceLocation("carnivore", resultId));
    }

    public static class CookingRecipe {
        private final ItemLike ingredient;
        private final ItemLike result;
        private final float experience;
        private final int smeltingTime;
        private final boolean createAllTypes;
        private final int campfireTime;
        private final int smokingTime;
        private final int blastingTime;
        private final boolean isShapeless;
        private final List<ItemLike> shapelessIngredients;
        private final int count;
        private final boolean isShaped;
        private final List<String> pattern;
        private final Map<Character, ItemLike> keys;
        private final ItemLike unlockItem;

        private CookingRecipe(ItemLike ingredient, ItemLike result, float experience, int smeltingTime, boolean createAllTypes, int campfireTime, int smokingTime, int blastingTime, boolean isShapeless, List<ItemLike> shapelessIngredients, int count, boolean isShaped, List<String> pattern, Map<Character, ItemLike> keys, ItemLike unlockItem) {
            this.ingredient = ingredient;
            this.result = result;
            this.experience = experience;
            this.smeltingTime = smeltingTime;
            this.createAllTypes = createAllTypes;
            this.campfireTime = campfireTime;
            this.smokingTime = smokingTime;
            this.blastingTime = blastingTime;
            this.isShapeless = isShapeless;
            this.shapelessIngredients = shapelessIngredients;
            this.count = count;
            this.isShaped = isShaped;
            this.pattern = pattern;
            this.keys = keys;
            this.unlockItem = unlockItem;
        }
    }
}

