/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.statemachine;

import com.tacz.guns.api.client.animation.AnimationController;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateContext;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.client.animation.statemachine.LuaContextWrapper;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public class LuaAnimationStateMachine<T extends AnimationStateContext>
extends AnimationStateMachine<LuaContextWrapper<T>> {
    Consumer<LuaContextWrapper<T>> initializeFunc;
    Consumer<LuaContextWrapper<T>> exitFunc;

    LuaAnimationStateMachine(AnimationController animationController) {
        super(animationController);
    }

    public void setContextOverride(@Nonnull T context) {
        if (this.context == null) {
            this.context = new LuaContextWrapper<T>(context);
        } else {
            Object oldContext = ((LuaContextWrapper)this.context).getContext();
            if (oldContext != context) {
                if (LuaAnimationStateMachine.areSameClass(oldContext, context)) {
                    ((LuaContextWrapper)this.context).setContext(context);
                } else {
                    this.context = new LuaContextWrapper<T>(context);
                }
            }
        }
    }

    public T getContextOverride() {
        if (this.context == null) {
            return null;
        }
        return ((LuaContextWrapper)this.context).getContext();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initializeFunc.accept((LuaContextWrapper)this.context);
    }

    @Override
    public void exit() {
        this.exitFunc.accept((LuaContextWrapper)this.context);
        super.exit();
    }

    @Override
    public LuaContextWrapper<T> getContext() {
        throw new UnsupportedOperationException("call getContextOverride instead");
    }

    @Override
    public void setContext(@Nonnull LuaContextWrapper<T> ignore) {
        throw new UnsupportedOperationException("call setContextOverride instead");
    }

    private static boolean areSameClass(Object obj1, Object obj2) {
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getClass().equals(obj2.getClass());
    }
}

