/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.event.common;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.ApiStatus;

public class EntityHurtByGunEvent
extends Event {
    @Nullable
    protected Entity hurtEntity;
    @Nullable
    protected LivingEntity attacker;
    protected ResourceLocation gunId;
    protected float baseAmount;
    protected boolean isHeadShot;
    protected float headshotMultiplier;
    private final LogicalSide logicalSide;

    protected EntityHurtByGunEvent(@Nullable Entity hurtEntity, @Nullable LivingEntity attacker, ResourceLocation gunId, float baseAmount, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
        this.hurtEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.baseAmount = baseAmount;
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
    }

    @Nullable
    public Entity getHurtEntity() {
        return this.hurtEntity;
    }

    @Nullable
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    @ApiStatus.Obsolete
    public float getAmount() {
        return this.baseAmount * this.headshotMultiplier;
    }

    public float getBaseAmount() {
        return this.baseAmount;
    }

    public float getHeadshotMultiplier() {
        return this.headshotMultiplier;
    }

    public boolean isHeadShot() {
        return this.isHeadShot;
    }

    public LogicalSide getLogicalSide() {
        return this.logicalSide;
    }

    public static class Post
    extends EntityHurtByGunEvent {
        public Post(@Nullable Entity hurtEntity, @Nullable LivingEntity attacker, ResourceLocation gunId, float amount, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(hurtEntity, attacker, gunId, amount, isHeadShot, headshotMultiplier, logicalSide);
        }
    }

    @Cancelable
    public static class Pre
    extends EntityHurtByGunEvent {
        public Pre(@Nullable Entity hurtEntity, @Nullable LivingEntity attacker, ResourceLocation gunId, float amount, boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(hurtEntity, attacker, gunId, amount, isHeadShot, headshotMultiplier, logicalSide);
            this.headshotMultiplier = headshotMultiplier;
        }

        public final void setHurtEntity(@Nullable Entity hurtEntity) {
            this.hurtEntity = hurtEntity;
        }

        public final void setAttacker(@Nullable LivingEntity attacker) {
            this.attacker = attacker;
        }

        public final void setGunId(ResourceLocation gunId) {
            this.gunId = gunId;
        }

        public final void setBaseAmount(float baseAmount) {
            this.baseAmount = baseAmount;
        }

        public final void setHeadshot(boolean headshot) {
            this.isHeadShot = headshot;
        }

        public final void setHeadshotMultiplier(float headshotMultiplier) {
            this.headshotMultiplier = headshotMultiplier;
        }
    }
}

