/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.gun;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.client.renderer.item.GunItemRenderer;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public abstract class AbstractGunItem
extends Item
implements IGun {
    protected AbstractGunItem(Item.Properties pProperties) {
        super(pProperties);
    }

    private static Comparator<Map.Entry<ResourceLocation, CommonGunIndex>> idNameSort() {
        return Comparator.comparingInt(m -> ((CommonGunIndex)m.getValue()).getSort());
    }

    public abstract void bolt(ItemStack var1);

    public abstract void shoot(ItemStack var1, Supplier<Float> var2, Supplier<Float> var3, boolean var4, LivingEntity var5);

    public abstract void fireSelect(ItemStack var1);

    public abstract void melee(LivingEntity var1, ItemStack var2);

    public abstract void reloadAmmo(ItemStack var1, int var2, boolean var3);

    @Override
    public boolean allowAttachment(ItemStack gun, ItemStack attachmentItem) {
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachmentItem);
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null && iAttachment != null) {
            ResourceLocation gunId = iGun.getGunId(gun);
            ResourceLocation attachmentId = iAttachment.getAttachmentId(attachmentItem);
            return AllowAttachmentTagMatcher.match(gunId, attachmentId);
        }
        return false;
    }

    @Override
    public boolean allowAttachmentType(ItemStack gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun != null) {
            return TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).map(gunIndex -> {
                List<AttachmentType> allowAttachments = gunIndex.getGunData().getAllowAttachments();
                if (allowAttachments == null) {
                    return false;
                }
                return allowAttachments.contains((Object)type);
            }).orElse(false);
        }
        return false;
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public Component m_7626_(@Nonnull ItemStack stack) {
        ResourceLocation gunId = this.getGunId(stack);
        Optional<ClientGunIndex> gunIndex = TimelessAPI.getClientGunIndex(gunId);
        if (gunIndex.isPresent()) {
            return Component.m_237115_((String)gunIndex.get().getName());
        }
        return super.m_7626_(stack);
    }

    public static NonNullList<ItemStack> fillItemCategory(GunTabType type) {
        NonNullList stacks = NonNullList.m_122779_();
        TimelessAPI.getAllCommonGunIndex().stream().sorted(AbstractGunItem.idNameSort()).forEach(entry -> {
            String indexType;
            CommonGunIndex index = (CommonGunIndex)entry.getValue();
            GunData gunData = index.getGunData();
            String key = type.name().toLowerCase(Locale.US);
            if (key.equals(indexType = index.getType())) {
                ItemStack itemStack = GunItemBuilder.create().setId((ResourceLocation)entry.getKey()).setFireMode(gunData.getFireModeSet().get(0)).setAmmoCount(gunData.getAmmoAmount()).setAmmoInBarrel(true).build();
                stacks.add((Object)itemStack);
            }
        });
        return stacks;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                Minecraft minecraft = Minecraft.m_91087_();
                return new GunItemRenderer(minecraft.m_167982_(), minecraft.m_167973_());
            }
        });
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            Optional<CommonGunIndex> optional = TimelessAPI.getCommonGunIndex(this.getGunId(stack));
            if (optional.isPresent()) {
                CommonGunIndex gunIndex = optional.get();
                ResourceLocation ammoId = gunIndex.getGunData().getAmmoId();
                return Optional.of(new GunTooltip(stack, iGun, ammoId, gunIndex));
            }
        }
        return Optional.empty();
    }
}

