/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public interface GunItemDataAccessor
extends IGun {
    public static final String GUN_ID_TAG = "GunId";
    public static final String GUN_FIRE_MODE_TAG = "GunFireMode";
    public static final String GUN_HAS_BULLET_IN_BARREL = "HasBulletInBarrel";
    public static final String GUN_CURRENT_AMMO_COUNT_TAG = "GunCurrentAmmoCount";
    public static final String GUN_ATTACHMENT_BASE = "Attachment";
    public static final String GUN_EXP_TAG = "GunLevelExp";
    public static final String GUN_DUMMY_AMMO = "DummyAmmo";
    public static final String GUN_MAX_DUMMY_AMMO = "MaxDummyAmmo";
    public static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";

    @Override
    default public boolean useDummyAmmo(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        return nbt.m_128425_(GUN_DUMMY_AMMO, 3);
    }

    @Override
    default public int getDummyAmmoAmount(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        return Math.max(0, nbt.m_128451_(GUN_DUMMY_AMMO));
    }

    @Override
    default public void setDummyAmmoAmount(ItemStack gun, int amount) {
        CompoundTag nbt = gun.m_41784_();
        nbt.m_128405_(GUN_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public void addDummyAmmoAmount(ItemStack gun, int amount) {
        if (!this.useDummyAmmo(gun)) {
            return;
        }
        if (!this.hasMaxDummyAmmo(gun)) {
            return;
        }
        CompoundTag nbt = gun.m_41784_();
        amount = Math.min(this.getDummyAmmoAmount(gun) + amount, this.getMaxDummyAmmoAmount(gun));
        nbt.m_128405_(GUN_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public boolean hasMaxDummyAmmo(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        return nbt.m_128425_(GUN_MAX_DUMMY_AMMO, 3);
    }

    @Override
    default public int getMaxDummyAmmoAmount(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        return Math.max(0, nbt.m_128451_(GUN_MAX_DUMMY_AMMO));
    }

    @Override
    default public void setMaxDummyAmmoAmount(ItemStack gun, int amount) {
        CompoundTag nbt = gun.m_41784_();
        nbt.m_128405_(GUN_MAX_DUMMY_AMMO, Math.max(amount, 0));
    }

    @Override
    default public boolean hasAttachmentLock(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_ATTACHMENT_LOCK, 1)) {
            return nbt.m_128471_(GUN_ATTACHMENT_LOCK);
        }
        return false;
    }

    @Override
    default public void setAttachmentLock(ItemStack gun, boolean lock) {
        CompoundTag nbt = gun.m_41784_();
        nbt.m_128379_(GUN_ATTACHMENT_LOCK, lock);
    }

    @Override
    @Nonnull
    default public ResourceLocation getGunId(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_ID_TAG, 8)) {
            ResourceLocation gunId = ResourceLocation.m_135820_((String)nbt.m_128461_(GUN_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_GUN_ID);
        }
        return DefaultAssets.EMPTY_GUN_ID;
    }

    @Override
    default public void setGunId(ItemStack gun, @Nullable ResourceLocation gunId) {
        CompoundTag nbt = gun.m_41784_();
        if (gunId != null) {
            nbt.m_128359_(GUN_ID_TAG, gunId.toString());
        }
    }

    @Override
    default public int getLevel(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_EXP_TAG, 3)) {
            return this.getLevel(nbt.m_128451_(GUN_EXP_TAG));
        }
        return 0;
    }

    @Override
    default public int getExp(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_EXP_TAG, 3)) {
            return nbt.m_128451_(GUN_EXP_TAG);
        }
        return 0;
    }

    @Override
    default public int getExpToNextLevel(ItemStack gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level >= this.getMaxLevel()) {
            return 0;
        }
        int nextLevelExp = this.getExp(level + 1);
        return nextLevelExp - exp;
    }

    @Override
    default public int getExpCurrentLevel(ItemStack gun) {
        int exp = this.getExp(gun);
        int level = this.getLevel(exp);
        if (level <= 0) {
            return exp;
        }
        return exp - this.getExp(level - 1);
    }

    @Override
    default public FireMode getFireMode(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_FIRE_MODE_TAG, 8)) {
            return FireMode.valueOf(nbt.m_128461_(GUN_FIRE_MODE_TAG));
        }
        return FireMode.UNKNOWN;
    }

    @Override
    default public void setFireMode(ItemStack gun, @Nullable FireMode fireMode) {
        CompoundTag nbt = gun.m_41784_();
        if (fireMode != null) {
            nbt.m_128359_(GUN_FIRE_MODE_TAG, fireMode.name());
            return;
        }
        nbt.m_128359_(GUN_FIRE_MODE_TAG, FireMode.UNKNOWN.name());
    }

    @Override
    default public int getCurrentAmmoCount(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_CURRENT_AMMO_COUNT_TAG, 3)) {
            return nbt.m_128451_(GUN_CURRENT_AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default public void setCurrentAmmoCount(ItemStack gun, int ammoCount) {
        CompoundTag nbt = gun.m_41784_();
        nbt.m_128405_(GUN_CURRENT_AMMO_COUNT_TAG, Math.max(ammoCount, 0));
    }

    @Override
    default public void reduceCurrentAmmoCount(ItemStack gun) {
        this.setCurrentAmmoCount(gun, this.getCurrentAmmoCount(gun) - 1);
    }

    @Override
    @Nullable
    default public CompoundTag getAttachmentTag(ItemStack gun, AttachmentType type) {
        CompoundTag allItemStackTag;
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return null;
        }
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(key = GUN_ATTACHMENT_BASE + type.name(), 10) && (allItemStackTag = nbt.m_128469_(key)).m_128425_("tag", 10)) {
            return allItemStackTag.m_128469_("tag");
        }
        return null;
    }

    @Override
    @Nonnull
    default public ItemStack getAttachment(ItemStack gun, AttachmentType type) {
        String key;
        if (!this.allowAttachmentType(gun, type)) {
            return ItemStack.f_41583_;
        }
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(key = GUN_ATTACHMENT_BASE + type.name(), 10)) {
            return ItemStack.m_41712_((CompoundTag)nbt.m_128469_(key));
        }
        return ItemStack.f_41583_;
    }

    @Override
    @Nonnull
    default public ResourceLocation getAttachmentId(ItemStack gun, AttachmentType type) {
        CompoundTag attachmentTag = this.getAttachmentTag(gun, type);
        if (attachmentTag != null) {
            return AttachmentItemDataAccessor.getAttachmentIdFromTag(attachmentTag);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    default public void installAttachment(@Nonnull ItemStack gun, @Nonnull ItemStack attachment) {
        if (!this.allowAttachment(gun, attachment)) {
            return;
        }
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachment);
        if (iAttachment == null) {
            return;
        }
        CompoundTag nbt = gun.m_41784_();
        String key = GUN_ATTACHMENT_BASE + iAttachment.getType(attachment).name();
        CompoundTag attachmentTag = new CompoundTag();
        attachment.m_41739_(attachmentTag);
        nbt.m_128365_(key, (Tag)attachmentTag);
    }

    @Override
    default public void unloadAttachment(@Nonnull ItemStack gun, AttachmentType type) {
        if (!this.allowAttachmentType(gun, type)) {
            return;
        }
        CompoundTag nbt = gun.m_41784_();
        String key = GUN_ATTACHMENT_BASE + type.name();
        CompoundTag attachmentTag = new CompoundTag();
        ItemStack.f_41583_.m_41739_(attachmentTag);
        nbt.m_128365_(key, (Tag)attachmentTag);
    }

    @Override
    default public float getAimingZoom(ItemStack gunItem) {
        float zoom = 1.0f;
        ResourceLocation scopeId = this.getAttachmentId(gunItem, AttachmentType.SCOPE);
        if (!DefaultAssets.isEmptyAttachmentId(scopeId)) {
            CompoundTag attachmentTag = this.getAttachmentTag(gunItem, AttachmentType.SCOPE);
            int zoomNumber = AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag);
            float[] zooms = TimelessAPI.getClientAttachmentIndex(scopeId).map(ClientAttachmentIndex::getZoom).orElse(null);
            if (zooms != null) {
                zoom = zooms[zoomNumber % zooms.length];
            }
        } else {
            ResourceLocation gunId = this.getGunId(gunItem);
            zoom = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        }
        return zoom;
    }

    @Override
    default public boolean hasBulletInBarrel(ItemStack gun) {
        CompoundTag nbt = gun.m_41784_();
        if (nbt.m_128425_(GUN_HAS_BULLET_IN_BARREL, 1)) {
            return nbt.m_128471_(GUN_HAS_BULLET_IN_BARREL);
        }
        return false;
    }

    @Override
    default public void setBulletInBarrel(ItemStack gun, boolean bulletInBarrel) {
        CompoundTag nbt = gun.m_41784_();
        nbt.m_128379_(GUN_HAS_BULLET_IN_BARREL, bulletInBarrel);
    }
}

