/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.event.BeforeRenderHandEvent;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.resource.pojo.data.attachment.RecoilModifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import com.tacz.guns.util.math.MathUtil;
import com.tacz.guns.util.math.SecondOrderDynamics;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.joml.Quaternionf;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class CameraSetupEvent {
    private static final SecondOrderDynamics WORLD_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static final SecondOrderDynamics ITEM_MODEL_FOV_DYNAMICS = new SecondOrderDynamics(0.5f, 1.2f, 0.5f, 0.0f);
    private static PolynomialSplineFunction pitchSplineFunction;
    private static PolynomialSplineFunction yawSplineFunction;
    private static long shootTimeStamp;
    private static double xRotO;
    private static double yRot0;
    private static BedrockGunModel lastModel;

    @SubscribeEvent
    public static void applyLevelCameraAnimation(ViewportEvent.ComputeCameraAngles event) {
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        TimelessAPI.getClientGunIndex(iGun.getGunId(stack)).ifPresent(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            if (lastModel != gunModel) {
                gunModel.cleanCameraAnimationTransform();
                lastModel = gunModel;
            }
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf q = MathUtil.multiplyQuaternion(gunModel.getCameraAnimationObject().rotationQuaternion, multiplier);
            double yaw = Math.asin(2.0f * (q.w() * q.y() - q.x() * q.z()));
            double pitch = Math.atan2(2.0f * (q.w() * q.x() + q.y() * q.z()), 1.0f - 2.0f * (q.x() * q.x() + q.y() * q.y()));
            double roll = Math.atan2(2.0f * (q.w() * q.z() + q.x() * q.y()), 1.0f - 2.0f * (q.y() * q.y() + q.z() * q.z()));
            yaw = Math.toDegrees(yaw);
            pitch = Math.toDegrees(pitch);
            roll = Math.toDegrees(roll);
            event.setYaw((float)yaw + event.getYaw());
            event.setPitch((float)pitch + event.getPitch());
            event.setRoll((float)roll + event.getRoll());
        });
    }

    @SubscribeEvent
    public static void applyItemInHandCameraAnimation(BeforeRenderHandEvent event) {
        if (!((Boolean)Minecraft.m_91087_().f_91066_.m_231830_().m_231551_()).booleanValue()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        TimelessAPI.getClientGunIndex(iGun.getGunId(stack)).ifPresent(gunIndex -> {
            BedrockGunModel gunModel = gunIndex.getGunModel();
            PoseStack poseStack = event.getPoseStack();
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(stack);
            float multiplier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            Quaternionf quaternion = MathUtil.multiplyQuaternion(gunModel.getCameraAnimationObject().rotationQuaternion, multiplier);
            poseStack.m_252781_(quaternion);
            gunModel.cleanCameraAnimationTransform();
        });
    }

    @SubscribeEvent
    public static void applyScopeMagnification(ViewportEvent.ComputeFov event) {
        if (!event.usedConfiguredFov()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            Item item = stack.m_41720_();
            if (!(item instanceof IGun)) {
                float fov = WORLD_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV((double)fov);
                return;
            }
            IGun iGun = (IGun)item;
            float zoom = iGun.getAimingZoom(stack);
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV((double)fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = WORLD_FOV_DYNAMICS.update((float)MathUtil.magnificationToFov(1.0f + (zoom - 1.0f) * aimingProgress, event.getFOV()));
                event.setFOV((double)fov);
            }
        }
    }

    @SubscribeEvent
    public static void applyGunModelFovModifying(ViewportEvent.ComputeFov event) {
        if (event.usedConfiguredFov()) {
            return;
        }
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            Item item = stack.m_41720_();
            if (!(item instanceof IGun)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV((double)fov);
                return;
            }
            IGun iGun = (IGun)item;
            ResourceLocation scopeItemId = iGun.getAttachmentId(stack, AttachmentType.SCOPE);
            if (DefaultAssets.isEmptyAttachmentId(scopeItemId)) {
                float fov = ITEM_MODEL_FOV_DYNAMICS.update((float)event.getFOV());
                event.setFOV((double)fov);
                return;
            }
            float modifiedFov = TimelessAPI.getClientAttachmentIndex(scopeItemId).map(ClientAttachmentIndex::getFov).orElse(Float.valueOf((float)event.getFOV())).floatValue();
            if (livingEntity instanceof LocalPlayer) {
                LocalPlayer localPlayer = (LocalPlayer)livingEntity;
                IClientPlayerGunOperator gunOperator = IClientPlayerGunOperator.fromLocalPlayer(localPlayer);
                float aimingProgress = gunOperator.getClientAimingProgress((float)event.getPartialTick());
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(Mth.m_14179_((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV((double)fov);
            } else {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity(livingEntity);
                float aimingProgress = gunOperator.getSynAimingProgress();
                float fov = ITEM_MODEL_FOV_DYNAMICS.update(Mth.m_14179_((float)aimingProgress, (float)((float)event.getFOV()), (float)modifiedFov));
                event.setFOV((double)fov);
            }
        }
    }

    @SubscribeEvent
    public static void initialCameraRecoil(GunFireEvent event) {
        if (event.getLogicalSide().isClient()) {
            LocalPlayer player;
            LivingEntity shooter = event.getShooter();
            if (!shooter.equals((Object)(player = Minecraft.m_91087_().f_91074_))) {
                return;
            }
            ItemStack mainhandItem = player.m_21205_();
            Item item = mainhandItem.m_41720_();
            if (!(item instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)item;
            ResourceLocation gunId = iGun.getGunId(mainhandItem);
            Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
            if (gunIndexOptional.isEmpty()) {
                return;
            }
            ClientGunIndex gunIndex = gunIndexOptional.get();
            GunData gunData = gunIndex.getGunData();
            float[] attachmentRecoilModifier = new float[]{0.0f, 0.0f};
            AttachmentDataUtils.getAllAttachmentData(mainhandItem, gunData, attachmentData -> {
                RecoilModifier recoilModifier = attachmentData.getRecoilModifier();
                if (recoilModifier == null) {
                    return;
                }
                attachmentRecoilModifier[0] = attachmentRecoilModifier[0] + recoilModifier.getPitch();
                attachmentRecoilModifier[1] = attachmentRecoilModifier[1] + recoilModifier.getYaw();
            });
            IClientPlayerGunOperator clientPlayerGunOperator = IClientPlayerGunOperator.fromLocalPlayer(player);
            float partialTicks = Minecraft.m_91087_().m_91296_();
            float aimingProgress = clientPlayerGunOperator.getClientAimingProgress(partialTicks);
            float zoom = iGun.getAimingZoom(mainhandItem);
            float aimingRecoilModifier = 1.0f - aimingProgress + aimingProgress / (float)Math.sqrt(zoom);
            pitchSplineFunction = gunData.getRecoil().genPitchSplineFunction(CameraSetupEvent.modifierNumber(attachmentRecoilModifier[0]) * aimingRecoilModifier);
            yawSplineFunction = gunData.getRecoil().genYawSplineFunction(CameraSetupEvent.modifierNumber(attachmentRecoilModifier[1]) * aimingRecoilModifier);
            shootTimeStamp = System.currentTimeMillis();
            xRotO = 0.0;
        }
    }

    @SubscribeEvent
    public static void applyCameraRecoil(ViewportEvent.ComputeCameraAngles event) {
        double value;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        long timeTotal = System.currentTimeMillis() - shootTimeStamp;
        if (pitchSplineFunction != null && pitchSplineFunction.isValidPoint((double)timeTotal)) {
            value = pitchSplineFunction.value((double)timeTotal);
            player.m_146926_(player.m_146909_() - (float)(value - xRotO));
            xRotO = value;
        }
        if (yawSplineFunction != null && yawSplineFunction.isValidPoint((double)timeTotal)) {
            value = yawSplineFunction.value((double)timeTotal);
            player.m_146922_(player.m_146908_() - (float)(value - yRot0));
            yRot0 = value;
        }
    }

    private static float modifierNumber(float modifier) {
        return Math.max(0.0f, 1.0f + modifier);
    }

    static {
        shootTimeStamp = -1L;
        xRotO = 0.0;
        yRot0 = 0.0;
        lastModel = null;
    }
}

