/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateMachine;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessagePlayerReloadGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.util.AttachmentDataUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class LocalPlayerReload {
    private final LocalPlayerDataHolder data;
    private final LocalPlayer player;

    public LocalPlayerReload(LocalPlayerDataHolder data, LocalPlayer player) {
        this.data = data;
        this.player = player;
    }

    public void reload() {
        ItemStack mainhandItem = this.player.m_21205_();
        Item item = mainhandItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(mainhandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.data.clientStateLock) {
                return;
            }
            if (IGunOperator.fromLivingEntity((LivingEntity)this.player).needCheckAmmo() && !this.inventoryHasAmmo(iGun, (ClientGunIndex)gunIndex, mainhandItem)) {
                return;
            }
            this.data.lockState(operator -> operator.getSynReloadState().getStateType().isReloading());
            if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent((LivingEntity)this.player, this.player.m_21205_(), LogicalSide.CLIENT))) {
                return;
            }
            NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessagePlayerReloadGun());
            this.doReload(iGun, (ClientGunIndex)gunIndex, mainhandItem);
        });
    }

    private void doReload(IGun iGun, ClientGunIndex gunIndex, ItemStack mainhandItem) {
        GunAnimationStateMachine animationStateMachine = gunIndex.getAnimationStateMachine();
        if (animationStateMachine != null) {
            Bolt boltType = gunIndex.getGunData().getBolt();
            boolean noAmmo = boltType == Bolt.OPEN_BOLT ? iGun.getCurrentAmmoCount(mainhandItem) <= 0 : !iGun.hasBulletInBarrel(mainhandItem);
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playReloadSound((LivingEntity)this.player, gunIndex, noAmmo);
            animationStateMachine.setNoAmmo(noAmmo).onGunReload();
        }
    }

    private void playMagExtendedAnimation(ItemStack mainhandItem, IGun iGun, GunAnimationStateMachine animationStateMachine) {
        ResourceLocation extendedMagId = iGun.getAttachmentId(mainhandItem, AttachmentType.EXTENDED_MAG);
        if (!DefaultAssets.isEmptyAttachmentId(extendedMagId)) {
            TimelessAPI.getCommonAttachmentIndex(extendedMagId).ifPresent(index -> animationStateMachine.setMagExtended(index.getData().getExtendedMagLevel() > 0));
        }
    }

    private boolean inventoryHasAmmo(IGun iGun, ClientGunIndex gunIndex, ItemStack mainhandItem) {
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(mainhandItem, gunIndex.getGunData());
        if (iGun.getCurrentAmmoCount(mainhandItem) >= maxAmmoCount) {
            return false;
        }
        if (iGun.useDummyAmmo(mainhandItem)) {
            return iGun.getDummyAmmoAmount(mainhandItem) > 0;
        }
        Inventory inventory = this.player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            ItemStack checkAmmo = inventory.m_8020_(i);
            Item item = checkAmmo.m_41720_();
            if (item instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(mainhandItem, checkAmmo)) {
                return true;
            }
            item = checkAmmo.m_41720_();
            if (!(item instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)item).isAmmoBoxOfGun(mainhandItem, checkAmmo)) continue;
            return true;
        }
        return false;
    }
}

