/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gui.components.smith.ResultButton;
import com.tacz.guns.client.gui.components.smith.TypeButton;
import com.tacz.guns.client.resource.ClientAssetManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModCreativeTabs;
import com.tacz.guns.inventory.GunSmithTableMenu;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ClientMessageCraft;
import com.tacz.guns.util.RenderDistance;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class GunSmithTableScreen
extends AbstractContainerScreen<GunSmithTableMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("tacz", "textures/gui/gun_smith_table.png");
    private static final ResourceLocation SIDE = new ResourceLocation("tacz", "textures/gui/gun_smith_table_side.png");
    private final List<String> recipeKeys = Lists.newArrayList();
    private final Map<String, List<ResourceLocation>> recipes = Maps.newHashMap();
    private int typePage;
    private String selectedType;
    private List<ResourceLocation> selectedRecipeList;
    private int indexPage;
    @Nullable
    private GunSmithTableRecipe selectedRecipe;
    @Nullable
    private Int2IntArrayMap playerIngredientCount;
    private int scale = 70;

    public GunSmithTableScreen(GunSmithTableMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 344;
        this.f_97727_ = 186;
        this.classifyRecipes();
        this.typePage = 0;
        this.selectedType = "ammo";
        this.selectedRecipeList = this.recipes.get(this.selectedType);
        this.indexPage = 0;
        this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList.get(0));
        this.getPlayerIngredientCount(this.selectedRecipe);
    }

    public static void drawModCenteredString(GuiGraphics gui, Font font, Component component, int pX, int pY, int color) {
        FormattedCharSequence text = component.m_7532_();
        gui.m_280649_(font, text, pX - font.m_92724_(text) / 2, pY, color, false);
    }

    private void classifyRecipes() {
        this.putRecipeType(ModCreativeTabs.AMMO_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_EXTENDED_MAG_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_SCOPE_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_MUZZLE_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_STOCK_TAB);
        this.putRecipeType(ModCreativeTabs.ATTACHMENT_GRIP_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_PISTOL_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SNIPER_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_RIFLE_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SHOTGUN_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_SMG_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_RPG_TAB);
        this.putRecipeType(ModCreativeTabs.GUN_MG_TAB);
        TimelessAPI.getAllRecipes().forEach((id, recipe) -> {
            String groupName = recipe.getResult().getGroup();
            if (this.recipeKeys.contains(groupName)) {
                this.recipes.computeIfAbsent(groupName, g -> Lists.newArrayList()).add(id);
            }
        });
    }

    private void putRecipeType(RegistryObject<CreativeModeTab> tab) {
        String name = tab.getId().m_135815_();
        this.recipeKeys.add(name);
    }

    @Nullable
    private GunSmithTableRecipe getSelectedRecipe(ResourceLocation recipeId) {
        return TimelessAPI.getAllRecipes().get(recipeId);
    }

    private void getPlayerIngredientCount(GunSmithTableRecipe recipe) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        List<GunSmithTableIngredient> ingredients = recipe.getInputs();
        int size = ingredients.size();
        this.playerIngredientCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; ++i) {
            GunSmithTableIngredient ingredient = ingredients.get(i);
            Inventory inventory = player.m_150109_();
            int count = 0;
            for (ItemStack stack : inventory.f_35974_) {
                if (stack.m_41619_() || !ingredient.getIngredient().test(stack)) continue;
                count += stack.m_41613_();
            }
            this.playerIngredientCount.put(i, count);
        }
    }

    public void updateIngredientCount() {
        if (this.selectedRecipe != null) {
            this.getPlayerIngredientCount(this.selectedRecipe);
        }
        this.m_7856_();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.addTypePageButtons();
        this.addTypeButtons();
        this.addIndexPageButtons();
        this.addIndexButtons();
        this.addScaleButtons();
        this.addCraftButton();
        this.addUrlButton();
    }

    private void addCraftButton() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 289, this.f_97736_ + 162, 48, 18, 138, 164, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null && this.playerIngredientCount != null) {
                List<GunSmithTableIngredient> inputs = this.selectedRecipe.getInputs();
                int size = inputs.size();
                for (int i = 0; i < size; ++i) {
                    int needCount;
                    if (i >= this.playerIngredientCount.size()) {
                        return;
                    }
                    int hasCount = this.playerIngredientCount.get(i);
                    if (hasCount >= (needCount = inputs.get(i).getCount())) continue;
                    return;
                }
                NetworkHandler.CHANNEL.sendToServer((Object)new ClientMessageCraft(this.selectedRecipe.m_6423_(), ((GunSmithTableMenu)this.f_97732_).f_38840_));
            }
        }));
    }

    private void addUrlButton() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 112, this.f_97736_ + 164, 18, 18, 149, 211, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null) {
                ResourceLocation id;
                ItemStack output = this.selectedRecipe.getOutput();
                Item item = output.m_41720_();
                if (item instanceof IGun) {
                    IGun iGun = (IGun)item;
                    id = iGun.getGunId(output);
                } else if (item instanceof IAttachment) {
                    IAttachment iAttachment = (IAttachment)item;
                    id = iAttachment.getAttachmentId(output);
                } else if (item instanceof IAmmo) {
                    IAmmo iAmmo = (IAmmo)item;
                    id = iAmmo.getAmmoId(output);
                } else {
                    return;
                }
                PackInfo packInfo = ClientAssetManager.INSTANCE.getPackInfo(id);
                if (packInfo == null) {
                    return;
                }
                String url = packInfo.getUrl();
                if (StringUtils.isNotBlank((CharSequence)url) && this.f_96541_ != null) {
                    this.f_96541_.m_91152_((Screen)new ConfirmLinkScreen(yes -> {
                        if (yes) {
                            Util.m_137581_().m_137646_(url);
                        }
                        this.f_96541_.m_91152_((Screen)this);
                    }, url, false));
                }
            }
        }));
    }

    private void addIndexButtons() {
        int finalIndex;
        if (this.selectedRecipeList == null || this.selectedRecipeList.isEmpty()) {
            return;
        }
        for (int i = 0; i < 6 && (finalIndex = i + this.indexPage * 6) < this.selectedRecipeList.size(); ++i) {
            int yOffset = this.f_97736_ + 66 + 17 * i;
            TimelessAPI.getRecipe(this.selectedRecipeList.get(finalIndex)).ifPresent(recipe -> {
                ResultButton button = (ResultButton)this.m_142416_((GuiEventListener)new ResultButton(this.f_97735_ + 144, yOffset, recipe.getOutput(), b -> {
                    this.selectedRecipe = recipe;
                    this.getPlayerIngredientCount(this.selectedRecipe);
                    this.m_7856_();
                }));
                if (this.selectedRecipe != null && recipe.m_6423_().equals((Object)this.selectedRecipe.m_6423_())) {
                    button.setSelected(true);
                }
            });
        }
    }

    private void addTypeButtons() {
        for (int i = 0; i < 7; ++i) {
            int typeIndex = this.typePage * 7 + i;
            if (typeIndex >= this.recipes.size()) {
                return;
            }
            String type = this.recipeKeys.get(typeIndex);
            int xOffset = this.f_97735_ + 157 + 24 * i;
            List<ResourceLocation> recipeIdGroups = this.recipes.get(type);
            if (recipeIdGroups.isEmpty()) continue;
            ItemStack icon = ItemStack.f_41583_;
            ResourceLocation tabId = new ResourceLocation("tacz", type);
            CreativeModeTab modTab = (CreativeModeTab)BuiltInRegistries.f_279662_.m_7745_(tabId);
            if (modTab != null) {
                icon = modTab.m_40787_();
            }
            TypeButton typeButton = new TypeButton(xOffset, this.f_97736_ + 2, icon, b -> {
                this.selectedType = type;
                this.selectedRecipeList = this.recipes.get(type);
                this.indexPage = 0;
                this.selectedRecipe = this.getSelectedRecipe(this.selectedRecipeList.get(0));
                this.getPlayerIngredientCount(this.selectedRecipe);
                this.m_7856_();
            });
            if (this.selectedType.equals(type)) {
                typeButton.setSelected(true);
            }
            this.m_142416_((GuiEventListener)typeButton);
        }
    }

    private void addIndexPageButtons() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 143, this.f_97736_ + 56, 96, 6, 40, 166, 6, TEXTURE, b -> {
            if (this.indexPage > 0) {
                --this.indexPage;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 143, this.f_97736_ + 171, 96, 6, 40, 186, 6, TEXTURE, b -> {
            int maxIndexPage;
            if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty() && this.indexPage < (maxIndexPage = (this.selectedRecipeList.size() - 1) / 6)) {
                ++this.indexPage;
                this.m_7856_();
            }
        }));
    }

    private void addTypePageButtons() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 136, this.f_97736_ + 4, 18, 20, 0, 162, 20, TEXTURE, b -> {
            if (this.typePage > 0) {
                --this.typePage;
                this.m_7856_();
            }
        }));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 327, this.f_97736_ + 4, 18, 20, 20, 162, 20, TEXTURE, b -> {
            int maxIndexPage = (this.recipes.size() - 1) / 7;
            if (this.typePage < maxIndexPage) {
                ++this.typePage;
                this.m_7856_();
            }
        }));
    }

    private void addScaleButtons() {
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_97736_ + 5, 10, 10, 188, 173, 10, TEXTURE, b -> {
            this.scale = Math.min(this.scale + 20, 200);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 17, this.f_97736_ + 5, 10, 10, 200, 173, 10, TEXTURE, b -> {
            this.scale = Math.max(this.scale - 20, 10);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 29, this.f_97736_ + 5, 10, 10, 212, 173, 10, TEXTURE, b -> {
            this.scale = 70;
        }));
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        GunSmithTableScreen.drawModCenteredString(graphics, this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.preview"), this.f_97735_ + 108, this.f_97736_ + 5, 0x555555);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)String.format("tacz.type.%s.name", this.selectedType)), this.f_97735_ + 150, this.f_97736_ + 32, 0x555555, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.ingredient"), this.f_97735_ + 254, this.f_97736_ + 50, 0x555555, false);
        GunSmithTableScreen.drawModCenteredString(graphics, this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.craft"), this.f_97735_ + 312, this.f_97736_ + 167, 0xFFFFFF);
        if (this.selectedRecipe != null) {
            this.renderLeftModel(this.selectedRecipe);
            this.renderPackInfo(graphics, this.selectedRecipe);
        }
        if (this.selectedRecipeList != null && !this.selectedRecipeList.isEmpty()) {
            this.renderIngredient(graphics);
        }
        this.f_169369_.stream().filter(w -> w instanceof ResultButton).forEach(w -> ((ResultButton)((Object)w)).renderTooltips(stack -> graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY)));
    }

    private void renderPackInfo(GuiGraphics gui, GunSmithTableRecipe recipe) {
        ResourceLocation id;
        ItemStack output = recipe.getOutput();
        Item item = output.m_41720_();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            id = iGun.getGunId(output);
        } else if (item instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)item;
            id = iAttachment.getAttachmentId(output);
        } else if (item instanceof IAmmo) {
            IAmmo iAmmo = (IAmmo)item;
            id = iAmmo.getAmmoId(output);
        } else {
            return;
        }
        PackInfo packInfo = ClientAssetManager.INSTANCE.getPackInfo(id);
        PoseStack poseStack = gui.m_280168_();
        if (packInfo != null) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.75f, 0.75f, 1.0f);
            MutableComponent nameText = Component.m_237115_((String)packInfo.getName());
            gui.m_280614_(this.f_96547_, (Component)nameText, (int)((float)(this.f_97735_ + 6) / 0.75f), (int)((float)(this.f_97736_ + 122) / 0.75f), ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.5f, 0.5f, 1.0f);
            int offsetX = (this.f_97735_ + 6) * 2;
            int offsetY = (this.f_97736_ + 123) * 2;
            int nameWidth = this.f_96547_.m_92852_((FormattedText)nameText);
            MutableComponent ver = Component.m_237113_((String)("v" + packInfo.getVersion())).m_130940_(ChatFormatting.UNDERLINE);
            gui.m_280614_(this.f_96547_, (Component)ver, (int)((float)offsetX + (float)nameWidth * 0.75f / 0.5f + 5.0f), offsetY, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
            offsetY += 14;
            String descKey = packInfo.getDescription();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{descKey})) {
                MutableComponent desc = Component.m_237115_((String)descKey);
                List split = this.f_96547_.m_92923_((FormattedText)desc, 245);
                for (FormattedCharSequence charSequence : split) {
                    gui.m_280649_(this.f_96547_, charSequence, offsetX, offsetY, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
                    Objects.requireNonNull(this.f_96547_);
                    offsetY += 9;
                }
                offsetY += 3;
            }
            gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.license").m_7220_((Component)Component.m_237113_((String)packInfo.getLicense()).m_130940_(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
            offsetY += 12;
            List<String> authors = packInfo.getAuthors();
            if (!authors.isEmpty()) {
                gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.authors").m_7220_((Component)Component.m_237113_((String)StringUtils.join(authors, (String)", ")).m_130940_(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
                offsetY += 12;
            }
            gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.date").m_7220_((Component)Component.m_237113_((String)packInfo.getDate()).m_130940_(ChatFormatting.DARK_GRAY)), offsetX, offsetY, ChatFormatting.DARK_GRAY.m_126665_().intValue(), false);
            poseStack.m_85849_();
        } else {
            ResourceLocation recipeId = recipe.m_6423_();
            gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.error").m_130940_(ChatFormatting.DARK_RED), this.f_97735_ + 6, this.f_97736_ + 122, 0xAF0000, false);
            gui.m_280614_(this.f_96547_, (Component)Component.m_237110_((String)"gui.tacz.gun_smith_table.error.id", (Object[])new Object[]{recipeId.toString()}).m_130940_(ChatFormatting.DARK_RED), this.f_97735_ + 6, this.f_97736_ + 134, 0xFFFFFF, false);
            PackInfo errorPackInfo = ClientAssetManager.INSTANCE.getPackInfo(recipeId);
            if (errorPackInfo != null) {
                gui.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)errorPackInfo.getName()).m_130940_(ChatFormatting.DARK_RED), this.f_97735_ + 6, this.f_97736_ + 146, 0xAF0000, false);
            }
        }
    }

    private void renderIngredient(GuiGraphics gui) {
        if (this.selectedRecipe == null) {
            return;
        }
        List<GunSmithTableIngredient> inputs = this.selectedRecipe.getInputs();
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 2; ++j) {
                int index = i * 2 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int offsetX = this.f_97735_ + 254 + 45 * j;
                int offsetY = this.f_97736_ + 62 + 17 * i;
                GunSmithTableIngredient smithTableIngredient = inputs.get(index);
                Ingredient ingredient = smithTableIngredient.getIngredient();
                ItemStack[] items = ingredient.m_43908_();
                int itemIndex = (int)(System.currentTimeMillis() / 1000L) % items.length;
                ItemStack item = items[itemIndex];
                gui.m_280203_(item, offsetX, offsetY);
                PoseStack poseStack = gui.m_280168_();
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 0.0f, 200.0f);
                poseStack.m_85841_(0.5f, 0.5f, 1.0f);
                int count = smithTableIngredient.getCount();
                int hasCount = 0;
                if (this.playerIngredientCount != null && index < this.playerIngredientCount.size()) {
                    hasCount = this.playerIngredientCount.get(index);
                }
                int color = count <= hasCount ? 0xFFFFFF : 0xFF0000;
                gui.m_280056_(this.f_96547_, String.format("%d/%d", count, hasCount), (offsetX + 17) * 2, (offsetY + 10) * 2, color, false);
                poseStack.m_85849_();
            }
        }
    }

    private void renderLeftModel(GunSmithTableRecipe recipe) {
        RenderDistance.markGuiRenderTimestamp();
        float rotationPeriod = 8.0f;
        int xPos = this.f_97735_ + 60;
        int yPos = this.f_97736_ + 50;
        int startX = this.f_97735_ + 3;
        int startY = this.f_97736_ + 16;
        int width = 128;
        int height = 99;
        float rotPitch = 15.0f;
        Window window = Minecraft.m_91087_().m_91268_();
        double windowGuiScale = window.m_85449_();
        int scissorX = (int)((double)startX * windowGuiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)(startY + height) * windowGuiScale);
        int scissorW = (int)((double)width * windowGuiScale);
        int scissorH = (int)((double)height * windowGuiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
        Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118259_);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_252880_((float)xPos, (float)yPos, 200.0f);
        posestack.m_85837_(8.0, 8.0, 0.0);
        posestack.m_85841_(1.0f, -1.0f, 1.0f);
        posestack.m_85841_((float)this.scale, (float)this.scale, (float)this.scale);
        float rot = (float)(System.currentTimeMillis() % (long)((int)(rotationPeriod * 1000.0f))) * (360.0f / (rotationPeriod * 1000.0f));
        posestack.m_252781_(Axis.f_252529_.m_252977_(rotPitch));
        posestack.m_252781_(Axis.f_252436_.m_252977_(rot));
        RenderSystem.applyModelViewMatrix();
        PoseStack tmpPose = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        Lighting.m_84930_();
        Minecraft.m_91087_().m_91291_().m_269128_(recipe.getOutput(), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, tmpPose, (MultiBufferSource)bufferSource, null, 0);
        bufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableScissor();
    }

    protected void m_280003_(@NotNull GuiGraphics gui, int mouseX, int mouseY) {
    }

    protected void m_7286_(@NotNull GuiGraphics gui, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(gui);
        gui.m_280218_(SIDE, this.f_97735_, this.f_97736_, 0, 0, 134, 187);
        gui.m_280218_(TEXTURE, this.f_97735_ + 136, this.f_97736_ + 27, 0, 0, 208, 160);
    }

    public boolean m_7043_() {
        return false;
    }
}

