/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class GunHudOverlay
implements IGuiOverlay {
    private static final ResourceLocation SEMI = new ResourceLocation("tacz", "textures/hud/fire_mode_semi.png");
    private static final ResourceLocation AUTO = new ResourceLocation("tacz", "textures/hud/fire_mode_auto.png");
    private static final ResourceLocation BURST = new ResourceLocation("tacz", "textures/hud/fire_mode_burst.png");
    private static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static long checkAmmoTimestamp = -1L;
    private static int cacheMaxAmmoCount = 0;
    private static int cacheInventoryAmmoCount = 0;

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(stack);
        ClientGunIndex gunIndex = TimelessAPI.getClientGunIndex(gunId).orElse(null);
        if (gunIndex == null) {
            return;
        }
        int ammoCount = iGun.getCurrentAmmoCount(stack) + (iGun.hasBulletInBarrel(stack) && gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        int ammoCountColor = (double)ammoCount < (double)cacheMaxAmmoCount * 0.25 ? 0xFF5555 : 0xFFFFFF;
        String currentAmmoCountText = CURRENT_AMMO_FORMAT.format(ammoCount);
        GunHudOverlay.handleCacheCount(player, stack, gunIndex, iGun);
        graphics.m_280509_(width - 75, height - 43, width - 74, height - 25, -1);
        PoseStack poseStack = graphics.m_280168_();
        Font font = mc.f_91062_;
        poseStack.m_85836_();
        poseStack.m_85841_(1.5f, 1.5f, 1.0f);
        graphics.drawString(font, currentAmmoCountText, (float)(width - 70) / 1.5f, (float)(height - 43) / 1.5f, ammoCountColor, false);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.8f, 0.8f, 1.0f);
        String inventoryAmmoCountText = INVENTORY_AMMO_FORMAT.format(cacheInventoryAmmoCount);
        int inventoryAmmoCountColor = iGun.useDummyAmmo(stack) ? 0x55FFFF : 0xAAAAAA;
        graphics.drawString(font, inventoryAmmoCountText, ((float)(width - 68) + (float)mc.f_91062_.m_92895_(currentAmmoCountText) * 1.5f) / 0.8f, (float)(height - 43) / 0.8f, inventoryAmmoCountColor, false);
        poseStack.m_85849_();
        String minecraftVersion = SharedConstants.m_183709_().m_132493_();
        String modVersion = ModList.get().getModFileById("tacz").versionString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 1.0f);
        graphics.m_280488_(font, debugInfo, (int)((float)(width - 70) / 0.5f), (int)(((float)height - 29.0f) / 0.5f), -5592406);
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation hudTexture = gunIndex.getHUDTexture();
        @Nullable ResourceLocation hudEmptyTexture = gunIndex.getHudEmptyTexture();
        if (ammoCount <= 0) {
            if (hudEmptyTexture == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                hudTexture = hudEmptyTexture;
            }
        }
        graphics.m_280163_(hudTexture, width - 117, height - 44, 0.0f, 0.0f, 39, 13, 39, 13);
        FireMode fireMode = IGun.getMainhandFireMode((LivingEntity)player);
        ResourceLocation fireModeTexture = switch (fireMode) {
            case FireMode.AUTO -> AUTO;
            case FireMode.BURST -> BURST;
            default -> SEMI;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280163_(fireModeTexture, (int)((double)width - 68.5 + (double)mc.f_91062_.m_92895_(currentAmmoCountText) * 1.5), height - 38, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    private static void handleCacheCount(LocalPlayer player, ItemStack stack, ClientGunIndex gunIndex, IGun iGun) {
        if (System.currentTimeMillis() - checkAmmoTimestamp > 200L) {
            checkAmmoTimestamp = System.currentTimeMillis();
            cacheMaxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(stack, gunIndex.getGunData());
            if (IGunOperator.fromLivingEntity((LivingEntity)player).needCheckAmmo()) {
                if (iGun.useDummyAmmo(stack)) {
                    cacheInventoryAmmoCount = iGun.getDummyAmmoAmount(stack);
                } else {
                    GunHudOverlay.handleInventoryAmmo(stack, player.m_150109_());
                }
            } else {
                cacheInventoryAmmoCount = 9999;
            }
        }
    }

    private static void handleInventoryAmmo(ItemStack stack, Inventory inventory) {
        cacheInventoryAmmoCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            ItemStack inventoryItem = inventory.m_8020_(i);
            Item item = inventoryItem.m_41720_();
            if (item instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(stack, inventoryItem)) {
                cacheInventoryAmmoCount += inventoryItem.m_41613_();
            }
            if (!((item = inventoryItem.m_41720_()) instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)item).isAmmoBoxOfGun(stack, inventoryItem)) continue;
            if (iAmmoBox.isAllTypeCreative(inventoryItem) || iAmmoBox.isCreative(inventoryItem)) {
                cacheInventoryAmmoCount = 9999;
                return;
            }
            cacheInventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryItem);
        }
    }
}

