/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.audio.SoundBuffer;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.animation.bedrock.BedrockAnimationFile;
import com.tacz.guns.client.resource.pojo.display.ammo.AmmoDisplay;
import com.tacz.guns.client.resource.pojo.display.attachment.AttachmentDisplay;
import com.tacz.guns.client.resource.pojo.display.gun.GunDisplay;
import com.tacz.guns.client.resource.pojo.model.BedrockModelPOJO;
import com.tacz.guns.client.resource.pojo.model.BedrockVersion;
import com.tacz.guns.client.resource.pojo.skin.attachment.AttachmentSkin;
import com.tacz.guns.compat.playeranimator.PlayerAnimatorCompat;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum ClientAssetManager {
    INSTANCE;

    private final Map<String, PackInfo> customInfos = Maps.newHashMap();
    private final Map<ResourceLocation, GunDisplay> gunDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, AmmoDisplay> ammoDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, AttachmentDisplay> attachmentDisplays = Maps.newHashMap();
    private final Map<ResourceLocation, Map<ResourceLocation, AttachmentSkin>> attachmentSkins = Maps.newHashMap();
    private final Map<ResourceLocation, AnimationStructure> gltfAnimations = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockAnimationFile> bedrockAnimations = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockModelPOJO> models = Maps.newHashMap();
    private final Map<ResourceLocation, SoundBuffer> soundBuffers = Maps.newHashMap();
    private final Map<String, Map<String, String>> languages = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockAttachmentModel> tempAttachmentModelMap = Maps.newHashMap();
    private final Map<ResourceLocation, BedrockGunModel> tempGunModelMap = Maps.newHashMap();

    @Nullable
    private static BedrockAttachmentModel getAttachmentModel(BedrockModelPOJO modelPOJO) {
        BedrockAttachmentModel attachmentModel = null;
        if (BedrockVersion.isLegacyVersion(modelPOJO) && modelPOJO.getGeometryModelLegacy() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.LEGACY);
        }
        if (BedrockVersion.isNewVersion(modelPOJO) && modelPOJO.getGeometryModelNew() != null) {
            attachmentModel = new BedrockAttachmentModel(modelPOJO, BedrockVersion.NEW);
        }
        return attachmentModel;
    }

    public void putPackInfo(String namespace, PackInfo info) {
        this.customInfos.put(namespace, info);
    }

    public void putGunDisplay(ResourceLocation registryName, GunDisplay display) {
        this.gunDisplays.put(registryName, display);
    }

    public void putAmmoDisplay(ResourceLocation registryName, AmmoDisplay display) {
        this.ammoDisplays.put(registryName, display);
    }

    public void putAttachmentDisplay(ResourceLocation registryName, AttachmentDisplay display) {
        this.attachmentDisplays.put(registryName, display);
    }

    public void putAttachmentSkin(ResourceLocation registryName, AttachmentSkin skin) {
        this.attachmentSkins.compute(skin.getParent(), (name, map) -> {
            if (map == null) {
                map = Maps.newHashMap();
            }
            map.put(registryName, skin);
            return map;
        });
    }

    public void putGltfAnimation(ResourceLocation registryName, AnimationStructure animation) {
        this.gltfAnimations.put(registryName, animation);
    }

    public void putBedrockAnimation(ResourceLocation registryName, BedrockAnimationFile bedrockAnimationFile) {
        this.bedrockAnimations.put(registryName, bedrockAnimationFile);
    }

    public void putModel(ResourceLocation registryName, BedrockModelPOJO model) {
        this.models.put(registryName, model);
    }

    public void putSoundBuffer(ResourceLocation registryName, SoundBuffer soundBuffer) {
        this.soundBuffers.put(registryName, soundBuffer);
    }

    public void putLanguage(String region, Map<String, String> lang) {
        Map<String, String> languageMaps = this.languages.getOrDefault(region, Maps.newHashMap());
        languageMaps.putAll(lang);
        this.languages.put(region, languageMaps);
    }

    public GunDisplay getGunDisplay(ResourceLocation registryName) {
        return this.gunDisplays.get(registryName);
    }

    public AmmoDisplay getAmmoDisplay(ResourceLocation registryName) {
        return this.ammoDisplays.get(registryName);
    }

    @Nullable
    public AttachmentDisplay getAttachmentDisplay(ResourceLocation registryName) {
        return this.attachmentDisplays.get(registryName);
    }

    public Map<ResourceLocation, AttachmentSkin> getAttachmentSkins(ResourceLocation registryName) {
        return this.attachmentSkins.get(registryName);
    }

    public AnimationStructure getGltfAnimations(ResourceLocation registryName) {
        return this.gltfAnimations.get(registryName);
    }

    public BedrockAnimationFile getBedrockAnimations(ResourceLocation registryName) {
        return this.bedrockAnimations.get(registryName);
    }

    public BedrockModelPOJO getModels(ResourceLocation registryName) {
        return this.models.get(registryName);
    }

    public SoundBuffer getSoundBuffers(ResourceLocation registryName) {
        return this.soundBuffers.get(registryName);
    }

    public Map<String, String> getLanguages(String region) {
        return this.languages.get(region);
    }

    @Nullable
    public PackInfo getPackInfo(ResourceLocation id) {
        return this.customInfos.get(id.m_135827_());
    }

    @Nullable
    public BedrockAttachmentModel getOrLoadAttachmentModel(@Nullable ResourceLocation modelLocation) {
        if (modelLocation == null) {
            return null;
        }
        BedrockAttachmentModel model = this.tempAttachmentModelMap.get(modelLocation);
        if (model != null) {
            return model;
        }
        BedrockModelPOJO modelPOJO = this.getModels(modelLocation);
        if (modelPOJO == null) {
            return null;
        }
        BedrockAttachmentModel attachmentModel = ClientAssetManager.getAttachmentModel(modelPOJO);
        if (attachmentModel == null) {
            return null;
        }
        this.tempAttachmentModelMap.put(modelLocation, attachmentModel);
        return attachmentModel;
    }

    public void clearAll() {
        this.customInfos.clear();
        this.gunDisplays.clear();
        this.ammoDisplays.clear();
        this.attachmentDisplays.clear();
        this.attachmentSkins.clear();
        this.gltfAnimations.clear();
        this.bedrockAnimations.clear();
        this.models.clear();
        this.soundBuffers.clear();
        this.languages.clear();
        this.tempGunModelMap.clear();
        this.tempAttachmentModelMap.clear();
        PlayerAnimatorCompat.clearAllAnimationCache();
    }
}

