/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class FilePackTexture
extends AbstractTexture {
    private final ResourceLocation registerId;
    private final Path filePath;

    public FilePackTexture(ResourceLocation registerId, Path filePath) {
        this.registerId = registerId;
        this.filePath = filePath;
    }

    public void m_6704_(ResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        File textureFile = this.filePath.toFile();
        if (textureFile.isFile()) {
            try (InputStream stream = Files.newInputStream(textureFile.toPath(), new OpenOption[0]);){
                NativeImage imageIn = NativeImage.m_85058_((InputStream)stream);
                int width = imageIn.m_84982_();
                int height = imageIn.m_85084_();
                TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)width, (int)height);
                imageIn.m_85013_(0, 0, 0, 0, 0, width, height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ResourceLocation getRegisterId() {
        return this.registerId;
    }
}

