/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class ZipPackTexture
extends AbstractTexture {
    private final ResourceLocation registerId;
    private final Path zipFilePath;

    public ZipPackTexture(ResourceLocation registerId, String zipFilePath) {
        this.registerId = registerId;
        this.zipFilePath = Paths.get(zipFilePath, new String[0]);
    }

    public void m_6704_(@Nonnull ResourceManager manager) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::doLoad);
        } else {
            this.doLoad();
        }
    }

    private void doLoad() {
        try (ZipFile zipFile = new ZipFile(this.zipFilePath.toFile());){
            ZipEntry entry = zipFile.getEntry(String.format("%s/textures/%s.png", this.registerId.m_135827_(), this.registerId.m_135815_()));
            if (entry == null) {
                return;
            }
            try (InputStream stream = zipFile.getInputStream(entry);){
                NativeImage imageIn = NativeImage.m_85058_((InputStream)stream);
                int width = imageIn.m_84982_();
                int height = imageIn.m_85084_();
                TextureUtil.prepareImage((int)this.m_117963_(), (int)0, (int)width, (int)height);
                imageIn.m_85013_(0, 0, 0, 0, 0, width, height, false, false, false, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ResourceLocation getRegisterId() {
        return this.registerId;
    }
}

