/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.jei.entry;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AttachmentQueryEntry {
    private final ItemStack attachmentStack;
    private List<ItemStack> allowGunStacks;
    private List<ItemStack> extraAllowGunStacks;

    public AttachmentQueryEntry(ResourceLocation attachmentId, GunTabType type) {
        this.attachmentStack = AttachmentItemBuilder.create().setId(attachmentId).build();
        this.allowGunStacks = Lists.newArrayList();
        this.extraAllowGunStacks = Lists.newArrayList();
        this.addAllAllowGuns(type);
        this.dividedGuns();
    }

    public static List<AttachmentQueryEntry> getAllAttachmentQueryEntries() {
        ArrayList entries = Lists.newArrayList();
        TimelessAPI.getAllCommonAttachmentIndex().forEach(entry -> {
            for (GunTabType tabType : GunTabType.values()) {
                AttachmentQueryEntry queryEntry = new AttachmentQueryEntry((ResourceLocation)entry.getKey(), tabType);
                if (queryEntry.getAllowGunStacks().isEmpty()) continue;
                entries.add(queryEntry);
            }
        });
        return entries;
    }

    public ItemStack getAttachmentStack() {
        return this.attachmentStack;
    }

    public List<ItemStack> getAllowGunStacks() {
        return this.allowGunStacks;
    }

    public List<ItemStack> getExtraAllowGunStacks() {
        return this.extraAllowGunStacks;
    }

    private void addAllAllowGuns(GunTabType type) {
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String gunType;
            String tabType = type.name().toLowerCase(Locale.US);
            if (tabType.equals(gunType = ((CommonGunIndex)entry.getValue()).getType())) {
                ItemStack gun = GunItemBuilder.create().setId((ResourceLocation)entry.getKey()).build();
                Item patt2378$temp = gun.m_41720_();
                if (!(patt2378$temp instanceof IGun)) {
                    return;
                }
                IGun iGun = (IGun)patt2378$temp;
                if (iGun.allowAttachment(gun, this.attachmentStack)) {
                    this.allowGunStacks.add(gun);
                }
            }
        });
    }

    private void dividedGuns() {
        int size = this.allowGunStacks.size();
        if (size >= 60) {
            this.extraAllowGunStacks = this.allowGunStacks.subList(60, size);
            this.allowGunStacks = this.allowGunStacks.subList(0, 60);
        }
    }
}

