/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator;

import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.compat.playeranimator.animation.AnimationDataRegisterFactory;
import com.tacz.guns.compat.playeranimator.animation.AnimationManager;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorAssetManager;
import com.tacz.guns.compat.playeranimator.animation.PlayerAnimatorLoader;
import java.io.File;
import java.util.zip.ZipFile;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;

public class PlayerAnimatorCompat {
    public static ResourceLocation LOWER_ANIMATION = new ResourceLocation("tacz", "lower_animation");
    public static ResourceLocation LOOP_UPPER_ANIMATION = new ResourceLocation("tacz", "loop_upper_animation");
    public static ResourceLocation ONCE_UPPER_ANIMATION = new ResourceLocation("tacz", "once_upper_animation");
    public static ResourceLocation ROTATION_ANIMATION = new ResourceLocation("tacz", "rotation");
    private static final String MOD_ID = "playeranimator";
    private static boolean INSTALLED = false;

    public static void init() {
        INSTALLED = ModList.get().isLoaded(MOD_ID);
        if (PlayerAnimatorCompat.isInstalled()) {
            AnimationDataRegisterFactory.registerData();
            MinecraftForge.EVENT_BUS.register((Object)new AnimationManager());
        }
    }

    public static boolean loadAnimationFromZip(ZipFile zipFile, String zipPath) {
        if (PlayerAnimatorCompat.isInstalled()) {
            return PlayerAnimatorLoader.load(zipFile, zipPath);
        }
        return false;
    }

    public static void loadAnimationFromFile(File file) {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorLoader.load(file);
        }
    }

    public static void clearAllAnimationCache() {
        if (PlayerAnimatorCompat.isInstalled()) {
            PlayerAnimatorAssetManager.INSTANCE.clearAll();
        }
    }

    public static boolean hasPlayerAnimator3rd(LivingEntity livingEntity, ClientGunIndex gunIndex) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            return AnimationManager.hasPlayerAnimator3rd(gunIndex);
        }
        return false;
    }

    public static void stopAllAnimation(LivingEntity livingEntity) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            AnimationManager.stopAllAnimation(player);
        }
    }

    public static void playAnimation(LivingEntity livingEntity, ClientGunIndex gunIndex, float limbSwingAmount) {
        if (PlayerAnimatorCompat.isInstalled() && livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)livingEntity;
            AnimationManager.playLowerAnimation(player, gunIndex, limbSwingAmount);
            AnimationManager.playLoopUpperAnimation(player, gunIndex, limbSwingAmount);
            AnimationManager.playRotationAnimation(player, gunIndex);
        }
    }

    public static boolean isInstalled() {
        return INSTALLED;
    }
}

