/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.playeranimator.animation;

import com.google.common.collect.Maps;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.gson.AnimationSerializing;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public enum PlayerAnimatorAssetManager {
    INSTANCE;

    private final HashMap<ResourceLocation, HashMap<String, KeyframeAnimation>> animations = new HashMap();

    void putAnimation(ResourceLocation id, InputStream stream) throws IOException {
        List keyframeAnimations = AnimationSerializing.deserializeAnimation((InputStream)stream);
        for (KeyframeAnimation animation : keyframeAnimations) {
            Object v = animation.extraData.get("name");
            if (!(v instanceof String)) continue;
            String text = (String)v;
            String name = PlayerAnimationRegistry.serializeTextToString((String)text).toLowerCase(Locale.ENGLISH);
            this.animations.computeIfAbsent(id, k -> Maps.newHashMap()).put(name, animation);
        }
    }

    Optional<KeyframeAnimation> getAnimations(ResourceLocation id, String name) {
        HashMap<String, KeyframeAnimation> animationHashMap = this.animations.get(id);
        if (animationHashMap == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(animationHashMap.get(name));
    }

    public boolean containsKey(ResourceLocation id) {
        return this.animations.containsKey(id);
    }

    public void clearAll() {
        this.animations.clear();
    }
}

