/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.entity.KnockBackModifier;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import com.tacz.guns.api.event.server.AmmoHitBlockEvent;
import com.tacz.guns.client.particle.AmmoParticleSpawner;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.config.util.HeadShotAABBConfigRead;
import com.tacz.guns.init.ModDamageTypes;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import com.tacz.guns.network.message.event.ServerMessageGunKill;
import com.tacz.guns.particles.BulletHoleOption;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.util.HitboxHelper;
import com.tacz.guns.util.TacHitResult;
import com.tacz.guns.util.block.BlockRayTrace;
import com.tacz.guns.util.block.ProjectileExplosion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EntityKineticBullet
extends Projectile
implements IEntityAdditionalSpawnData {
    public static final EntityType<EntityKineticBullet> TYPE = EntityType.Builder.m_20704_(EntityKineticBullet::new, (MobCategory)MobCategory.MISC).m_20698_().m_20716_().m_20719_().m_20699_(0.0625f, 0.0625f).m_20702_(5).m_20717_(5).setShouldReceiveVelocityUpdates(false).m_20712_("bullet");
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.m_6087_() && !input.m_5833_();
    private ResourceLocation ammoId = DefaultAssets.EMPTY_AMMO_ID;
    private int life = 200;
    private float speed = 1.0f;
    private float gravity = 0.0f;
    private float friction = 0.01f;
    private float damageAmount = 5.0f;
    private float knockback = 0.0f;
    private boolean hasExplosion = false;
    private boolean hasIgnite = false;
    private int igniteEntityTime = 2;
    private float explosionDamage = 3.0f;
    private float explosionRadius = 3.0f;
    private int explosionDelayCount = Integer.MAX_VALUE;
    private boolean explosionKnockback = false;
    private ExtraDamage extraDamage = null;
    private float damageModifier = 1.0f;
    private int pierce = 1;
    private Vec3 startPos;
    private boolean isTracerAmmo;
    private Vec3 originCameraPosition;
    private Vec3 originRenderOffset;
    private ResourceLocation gunId;

    public EntityKineticBullet(EntityType<? extends Projectile> type, Level worldIn) {
        super(type, worldIn);
    }

    public EntityKineticBullet(EntityType<? extends Projectile> type, double x, double y, double z, Level worldIn) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
    }

    public EntityKineticBullet(Level worldIn, LivingEntity throwerIn, ResourceLocation ammoId, ResourceLocation gunId, boolean isTracerAmmo, BulletData data) {
        this(TYPE, throwerIn.m_20185_(), throwerIn.m_20188_() - (double)0.1f, throwerIn.m_20189_(), worldIn);
        this.m_5602_((Entity)throwerIn);
        this.ammoId = ammoId;
        this.life = Mth.m_14045_((int)((int)(data.getLifeSecond() * 20.0f)), (int)1, (int)Integer.MAX_VALUE);
        this.speed = Mth.m_14036_((float)(data.getSpeed() / 20.0f), (float)0.0f, (float)30.0f);
        this.gravity = Mth.m_14036_((float)data.getGravity(), (float)0.0f, (float)Float.MAX_VALUE);
        this.friction = Mth.m_14036_((float)data.getFriction(), (float)0.0f, (float)Float.MAX_VALUE);
        this.hasIgnite = data.isHasIgnite();
        this.igniteEntityTime = Math.max(data.getIgniteEntityTime(), 0);
        this.damageAmount = (float)Mth.m_14008_((double)((double)data.getDamageAmount() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)Double.MAX_VALUE);
        if (data.getBulletAmount() > 1) {
            this.damageModifier = 1.0f / (float)data.getBulletAmount();
        }
        this.knockback = Mth.m_14036_((float)data.getKnockback(), (float)0.0f, (float)Float.MAX_VALUE);
        this.pierce = Mth.m_14045_((int)data.getPierce(), (int)1, (int)Integer.MAX_VALUE);
        this.extraDamage = data.getExtraDamage();
        ExplosionData explosionData = data.getExplosionData();
        if (explosionData != null) {
            this.hasExplosion = true;
            this.explosionDamage = (float)Mth.m_14008_((double)((double)explosionData.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()), (double)0.0, (double)3.4028234663852886E38);
            this.explosionRadius = Mth.m_14036_((float)explosionData.getRadius(), (float)0.0f, (float)Float.MAX_VALUE);
            this.explosionKnockback = explosionData.isKnockback();
            int delayTickCount = explosionData.getDelay() * 20;
            if (delayTickCount < 0) {
                delayTickCount = Integer.MAX_VALUE;
            }
            this.explosionDelayCount = Math.max(delayTickCount, 1);
        }
        double posX = throwerIn.f_19790_ + (throwerIn.m_20185_() - throwerIn.f_19790_) / 2.0;
        double posY = throwerIn.f_19791_ + (throwerIn.m_20186_() - throwerIn.f_19791_) / 2.0 + (double)throwerIn.m_20192_();
        double posZ = throwerIn.f_19792_ + (throwerIn.m_20189_() - throwerIn.f_19792_) / 2.0;
        this.m_6034_(posX, posY, posZ);
        this.startPos = this.m_20182_();
        this.isTracerAmmo = isTracerAmmo;
        this.gunId = gunId;
    }

    public static void createExplosion(Entity owner, Entity exploder, float damage, float radius, boolean knockback, Vec3 hitPos) {
        ProjectileExplosion explosion;
        Level level = exploder.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        Explosion.BlockInteraction mode = Explosion.BlockInteraction.KEEP;
        if (((Boolean)AmmoConfig.EXPLOSIVE_AMMO_DESTROYS_BLOCKS.get()).booleanValue()) {
            mode = Explosion.BlockInteraction.DESTROY;
        }
        if (ForgeEventFactory.onExplosionStart((Level)level2, (Explosion)(explosion = new ProjectileExplosion((Level)level2, owner, exploder, null, null, hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), damage, radius, knockback, mode)))) {
            return;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (mode == Explosion.BlockInteraction.KEEP) {
            explosion.m_46080_();
        }
        level2.m_6907_().stream().filter(player -> Mth.m_14116_((float)((float)player.m_20238_(hitPos))) < (float)((Integer)AmmoConfig.EXPLOSIVE_AMMO_VISIBLE_DISTANCE.get()).intValue()).forEach(player -> {
            ClientboundExplodePacket packet = new ClientboundExplodePacket(hitPos.m_7096_(), hitPos.m_7098_(), hitPos.m_7094_(), radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player));
            player.f_8906_.m_9829_((Packet)packet);
        });
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        this.onBulletTick();
        if (this.m_9236_().f_46443_) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> AmmoParticleSpawner.addParticle(this, this.gunId));
        }
        Vec3 movement = this.m_20184_();
        double x = movement.f_82479_;
        double y = movement.f_82480_;
        double z = movement.f_82481_;
        double distance = movement.m_165924_();
        this.m_146922_((float)Math.toDegrees(Mth.m_14136_((double)x, (double)z)));
        this.m_146926_((float)Math.toDegrees(Mth.m_14136_((double)y, (double)distance)));
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        this.m_146926_(EntityKineticBullet.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
        this.m_146922_(EntityKineticBullet.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
        double nextPosX = this.m_20185_() + x;
        double nextPosY = this.m_20186_() + y;
        double nextPosZ = this.m_20189_() + z;
        this.m_6034_(nextPosX, nextPosY, nextPosZ);
        float friction = this.friction;
        float gravity = this.gravity;
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, nextPosX - x * 0.25, nextPosY - y * 0.25, nextPosZ - z * 0.25, x, y, z);
            }
            friction = 0.4f;
            gravity *= 0.6f;
        }
        this.m_20256_(this.m_20184_().m_82490_((double)(1.0f - friction)));
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-gravity), 0.0));
        if (this.f_19797_ >= this.life - 1) {
            this.m_146870_();
        }
    }

    protected void onBulletTick() {
        if (!this.m_9236_().m_5776_()) {
            if (this.hasExplosion) {
                if (this.explosionDelayCount > 0) {
                    --this.explosionDelayCount;
                } else {
                    EntityKineticBullet.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, this.m_20182_());
                    this.m_146870_();
                    return;
                }
            }
            Vec3 startVec = this.m_20182_();
            Vec3 endVec = startVec.m_82549_(this.m_20184_());
            Object result = BlockRayTrace.rayTraceBlocks(this.m_9236_(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockHitResult resultB = result;
            if (resultB.m_6662_() != HitResult.Type.MISS) {
                endVec = resultB.m_82450_();
            }
            List<EntityResult> hitEntities = null;
            if (this.pierce <= 1 || this.hasExplosion) {
                EntityResult entityResult = this.findEntityOnPath(startVec, endVec);
                if (entityResult != null) {
                    hitEntities = Collections.singletonList(entityResult);
                }
            } else {
                hitEntities = this.findEntitiesOnPath(startVec, endVec);
            }
            if (hitEntities != null && !hitEntities.isEmpty()) {
                EntityResult[] hitEntityResult = hitEntities.toArray(new EntityResult[0]);
                for (int i = 0; (i < this.pierce || i < 1) && i < hitEntityResult.length - 1; ++i) {
                    int k = i;
                    for (int j = i + 1; j < hitEntityResult.length; ++j) {
                        if (!(hitEntityResult[j].hitVec.m_82554_(startVec) < hitEntityResult[k].hitVec.m_82554_(startVec))) continue;
                        k = j;
                    }
                    EntityResult t = hitEntityResult[i];
                    hitEntityResult[i] = hitEntityResult[k];
                    hitEntityResult[k] = t;
                }
                for (EntityResult entityResult : hitEntityResult) {
                    result = new TacHitResult(entityResult);
                    this.onHitEntity((TacHitResult)((Object)result), startVec, endVec);
                    --this.pierce;
                    if (this.pierce >= 1 && !this.hasExplosion) continue;
                    this.m_146870_();
                    return;
                }
            }
            this.onHitBlock(resultB, startVec, endVec);
        }
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        Entity owner = this.m_19749_();
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.m_20202_()) || (result = this.getHitResult(entity, startVec, endVec)) == null) continue;
            Vec3 hitPos = result.getHitPos();
            double distanceToHit = startVec.m_82554_(hitPos);
            if (!entity.m_6084_() || !(distanceToHit < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), PROJECTILE_TARGETS);
        Entity owner = this.m_19749_();
        for (Entity entity : entities) {
            EntityResult result;
            if (entity.equals((Object)owner) || owner != null && entity.equals((Object)owner.m_20202_()) || (result = this.getHitResult(entity, startVec, endVec)) == null || !entity.m_6084_()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    protected EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        AABB aabb;
        AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.m_19749_());
        Vec3 hitPos = boundingBox.m_82371_(startVec, endVec).orElse(null);
        if (hitPos == null) {
            return null;
        }
        Vec3 hitBoxPos = hitPos.m_82546_(entity.m_20182_());
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityId != null && (aabb = HeadShotAABBConfigRead.getAABB(entityId)) != null) {
            return new EntityResult(entity, hitPos, aabb.m_82390_(hitBoxPos));
        }
        boolean headshot = false;
        float eyeHeight = entity.m_20192_();
        if ((double)eyeHeight - 0.25 < hitBoxPos.f_82480_ && hitBoxPos.f_82480_ < (double)eyeHeight + 0.25) {
            headshot = true;
        }
        return new EntityResult(entity, hitPos, headshot);
    }

    protected void onHitEntity(TacHitResult result, Vec3 startVec, Vec3 endVec) {
        LivingEntity partOwner;
        PartEntity part;
        Entity entity;
        EntityHurtByGunEvent.Pre preEvent;
        boolean cancelled;
        Entity entity2 = result.m_82443_();
        if (entity2 instanceof ITargetEntity) {
            ITargetEntity targetEntity = (ITargetEntity)entity2;
            DamageSource source = this.m_269291_().m_269390_((Entity)this, this.m_19749_());
            targetEntity.onProjectileHit((Entity)this, result, source, this.getDamage(result.m_82450_()));
            return;
        }
        Entity entity3 = result.m_82443_();
        @Nullable Entity owner = this.m_19749_();
        LivingEntity attacker = owner instanceof LivingEntity ? (LivingEntity)owner : null;
        boolean headshot = result.isHeadshot();
        float damage = this.getDamage(result.m_82450_());
        float headShotMultiplier = 1.0f;
        if (this.extraDamage != null && this.extraDamage.getHeadShotMultiplier() > 0.0f) {
            headShotMultiplier = (float)((double)this.extraDamage.getHeadShotMultiplier() * (Double)SyncConfig.HEAD_SHOT_BASE_MULTIPLIER.get());
        }
        if (cancelled = MinecraftForge.EVENT_BUS.post((Event)(preEvent = new EntityHurtByGunEvent.Pre(entity3, attacker, this.gunId, damage, headshot, headShotMultiplier, LogicalSide.SERVER)))) {
            return;
        }
        entity3 = preEvent.getHurtEntity();
        LivingEntity livingEntity = entity3 instanceof PartEntity && (entity = (part = (PartEntity)entity3).getParent()) instanceof LivingEntity ? (partOwner = (LivingEntity)entity) : (entity3 instanceof LivingEntity ? (LivingEntity)entity3 : null);
        attacker = preEvent.getAttacker();
        ResourceLocation newGunId = preEvent.getGunId();
        damage = preEvent.getBaseAmount();
        headshot = preEvent.isHeadShot();
        headShotMultiplier = preEvent.getHeadshotMultiplier();
        if (entity3 == null) {
            return;
        }
        if (this.hasIgnite && ((Boolean)AmmoConfig.IGNITE_ENTITY.get()).booleanValue()) {
            entity3.m_20254_(this.igniteEntityTime);
        }
        if (headshot) {
            damage *= headShotMultiplier;
        }
        if (livingEntity != null) {
            KnockBackModifier modifier = KnockBackModifier.fromLivingEntity(livingEntity);
            modifier.setKnockBackStrength(this.knockback);
            this.tacAttackEntity(entity3, damage);
            modifier.resetKnockBackStrength();
        } else {
            this.tacAttackEntity(entity3, damage);
        }
        if (this.hasExplosion) {
            entity3.f_19802_ = 0;
            EntityKineticBullet.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, result.m_82450_());
        }
        if (livingEntity != null && !this.m_9236_().f_46443_) {
            int attackerId;
            int n = attackerId = attacker == null ? 0 : attacker.m_19879_();
            if (livingEntity.m_21224_()) {
                MinecraftForge.EVENT_BUS.post((Event)new EntityKillByGunEvent(livingEntity, attacker, newGunId, headshot, LogicalSide.SERVER));
                NetworkHandler.sendToDimension(new ServerMessageGunKill(livingEntity.m_19879_(), attackerId, newGunId, headshot), (Entity)livingEntity);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new EntityHurtByGunEvent.Post((Entity)livingEntity, attacker, newGunId, damage, headshot, headShotMultiplier, LogicalSide.SERVER));
                NetworkHandler.sendToDimension(new ServerMessageGunHurt(livingEntity.m_19879_(), attackerId, newGunId, damage, headshot, headShotMultiplier), (Entity)livingEntity);
            }
        }
    }

    protected void onHitBlock(BlockHitResult result, Vec3 startVec, Vec3 endVec) {
        super.m_8060_(result);
        if (result.m_6662_() == HitResult.Type.MISS) {
            return;
        }
        Vec3 hitVec = result.m_82450_();
        BlockPos pos = result.m_82425_();
        if (MinecraftForge.EVENT_BUS.post((Event)new AmmoHitBlockEvent(this.m_9236_(), result, this.m_9236_().m_8055_(pos), this))) {
            return;
        }
        if (this.hasExplosion) {
            EntityKineticBullet.createExplosion(this.m_19749_(), (Entity)this, this.explosionDamage, this.explosionRadius, this.explosionKnockback, hitVec);
            this.m_146870_();
            return;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BulletHoleOption bulletHoleOption = new BulletHoleOption(result.m_82434_(), result.m_82425_(), this.ammoId.toString(), this.gunId.toString());
            serverLevel.m_8767_((ParticleOptions)bulletHoleOption, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            if (this.hasIgnite) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_, hitVec.f_82480_, hitVec.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (this.hasIgnite && ((Boolean)AmmoConfig.IGNITE_BLOCK.get()).booleanValue()) {
            BlockPos offsetPos = pos.m_121945_(result.m_82434_());
            if (BaseFireBlock.m_49255_((Level)this.m_9236_(), (BlockPos)offsetPos, (Direction)result.m_82434_())) {
                BlockState fireState = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)offsetPos);
                this.m_9236_().m_7731_(offsetPos, fireState, 11);
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123756_, hitVec.f_82479_ - 1.0 + this.f_19796_.m_188500_() * 2.0, hitVec.f_82480_, hitVec.f_82481_ - 1.0 + this.f_19796_.m_188500_() * 2.0, 4, 0.0, 0.0, 0.0, 0.0);
            }
        }
        this.m_146870_();
    }

    public float getDamage(Vec3 hitVec) {
        if (this.extraDamage == null) {
            return Math.max(0.0f, this.damageAmount * this.damageModifier);
        }
        LinkedList<ExtraDamage.DistanceDamagePair> damageDecay = this.extraDamage.getDamageAdjust();
        if (damageDecay == null || damageDecay.isEmpty()) {
            return Math.max(0.0f, this.damageAmount * this.damageModifier);
        }
        double playerDistance = hitVec.m_82554_(this.startPos);
        for (ExtraDamage.DistanceDamagePair pair : damageDecay) {
            if (!(playerDistance < (double)pair.getDistance())) continue;
            return (float)(Math.max(0.0, (double)pair.getDamage() * (Double)SyncConfig.DAMAGE_BASE_MULTIPLIER.get()) * (double)this.damageModifier);
        }
        return 0.0f;
    }

    private void tacAttackEntity(Entity entity, float damage) {
        DamageSource source = ModDamageTypes.Sources.bullet(this.m_9236_().m_9598_(), this, this.m_19749_(), false);
        float armorIgnore = 0.0f;
        if (this.extraDamage != null && this.extraDamage.getArmorIgnore() > 0.0f) {
            armorIgnore = (float)((double)this.extraDamage.getArmorIgnore() * (Double)SyncConfig.ARMOR_IGNORE_BASE_MULTIPLIER.get());
        }
        if (entity instanceof EnderMan) {
            source = this.m_269291_().m_269104_((Entity)this, this.m_19749_());
        }
        float armorDamagePercent = Mth.m_14036_((float)armorIgnore, (float)0.0f, (float)1.0f);
        float normalDamagePercent = 1.0f - armorDamagePercent;
        entity.f_19802_ = 0;
        entity.m_6469_(source, damage * normalDamagePercent);
        source = ModDamageTypes.Sources.bullet(this.m_9236_().m_9598_(), this, this.m_19749_(), true);
        entity.f_19802_ = 0;
        entity.m_6469_(source, damage * armorDamagePercent);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.m_146909_());
        buffer.writeFloat(this.m_146908_());
        buffer.writeDouble(this.m_20184_().f_82479_);
        buffer.writeDouble(this.m_20184_().f_82480_);
        buffer.writeDouble(this.m_20184_().f_82481_);
        Entity entity = this.m_19749_();
        buffer.writeInt(entity != null ? entity.m_19879_() : 0);
        buffer.m_130085_(this.ammoId);
        buffer.writeFloat(this.gravity);
        buffer.writeBoolean(this.hasExplosion);
        buffer.writeBoolean(this.hasIgnite);
        buffer.writeFloat(this.explosionRadius);
        buffer.writeFloat(this.explosionDamage);
        buffer.writeInt(this.life);
        buffer.writeFloat(this.speed);
        buffer.writeFloat(this.friction);
        buffer.writeInt(this.pierce);
        buffer.writeBoolean(this.isTracerAmmo);
        buffer.m_130085_(this.gunId);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.m_146926_(additionalData.readFloat());
        this.m_146922_(additionalData.readFloat());
        this.m_20334_(additionalData.readDouble(), additionalData.readDouble(), additionalData.readDouble());
        Entity entity = this.m_9236_().m_6815_(additionalData.readInt());
        if (entity != null) {
            this.m_5602_(entity);
        }
        this.ammoId = additionalData.m_130281_();
        this.gravity = additionalData.readFloat();
        this.hasExplosion = additionalData.readBoolean();
        this.hasIgnite = additionalData.readBoolean();
        this.explosionRadius = additionalData.readFloat();
        this.explosionDamage = additionalData.readFloat();
        this.life = additionalData.readInt();
        this.speed = additionalData.readFloat();
        this.friction = additionalData.readFloat();
        this.pierce = additionalData.readInt();
        this.isTracerAmmo = additionalData.readBoolean();
        this.gunId = additionalData.m_130281_();
    }

    public ResourceLocation getAmmoId() {
        return this.ammoId;
    }

    public ResourceLocation getGunId() {
        return this.gunId;
    }

    public boolean isTracerAmmo() {
        return this.isTracerAmmo;
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public Vec3 getOriginCameraPosition() {
        return this.originCameraPosition;
    }

    public void setOriginCameraPosition(Vec3 originCameraPosition) {
        this.originCameraPosition = originCameraPosition;
    }

    public Vec3 getOriginRenderOffset() {
        return this.originRenderOffset;
    }

    public void setOriginRenderOffset(Vec3 originRenderOffset) {
        this.originRenderOffset = originRenderOffset;
    }

    public boolean m_150171_(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return super.m_150171_(entity);
    }

    public static class EntityResult {
        private final Entity entity;
        private final Vec3 hitVec;
        private final boolean headshot;

        public EntityResult(Entity entity, Vec3 hitVec, boolean headshot) {
            this.entity = entity;
            this.hitVec = hitVec;
            this.headshot = headshot;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public Vec3 getHitPos() {
            return this.hitVec;
        }

        public boolean isHeadshot() {
            return this.headshot;
        }
    }
}

