/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity;

import com.mojang.authlib.GameProfile;
import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.api.event.common.EntityHurtByGunEvent;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.config.common.OtherConfig;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModBlocks;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModSounds;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunHurt;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMinecart
extends AbstractMinecart
implements ITargetEntity {
    public static EntityType<TargetMinecart> TYPE = EntityType.Builder.m_20704_(TargetMinecart::new, (MobCategory)MobCategory.MISC).m_20699_(0.75f, 2.4f).m_20702_(8).m_20712_("target_minecart");
    @Nullable
    private GameProfile gameProfile = null;

    public TargetMinecart(EntityType<TargetMinecart> type, Level world) {
        super(type, world);
    }

    public TargetMinecart(Level level, double x, double y, double z) {
        super(TYPE, level, x, y, z);
    }

    @Override
    public void onProjectileHit(Entity entity, EntityHitResult result, DamageSource source, float damage) {
        if (this.m_9236_().m_5776_() || this.m_213877_()) {
            return;
        }
        if (!source.m_269014_()) {
            return;
        }
        Entity sourceEntity = source.m_7639_();
        if (sourceEntity instanceof Player) {
            Player player = (Player)sourceEntity;
            this.m_38160_(-1);
            this.m_38154_(10);
            this.m_5834_();
            this.m_38109_(10.0f);
            double dis = this.m_20182_().m_82554_(sourceEntity.m_20182_());
            player.m_5661_((Component)Component.m_237110_((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{String.format("%.1f", Float.valueOf(damage)), String.format("%.2f", dis)}), true);
            float volume = (float)((Integer)OtherConfig.TARGET_SOUND_DISTANCE.get()).intValue() / 16.0f;
            volume = Math.max(volume, 0.0f);
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)ModSounds.TARGET_HIT.get(), SoundSource.BLOCKS, volume, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
            if (entity instanceof EntityKineticBullet) {
                EntityKineticBullet projectile = (EntityKineticBullet)entity;
                boolean isHeadshot = false;
                float headshotMultiplier = 1.0f;
                MinecraftForge.EVENT_BUS.post((Event)new EntityHurtByGunEvent.Post((Entity)this, (LivingEntity)player, projectile.getGunId(), damage, isHeadshot, headshotMultiplier, LogicalSide.SERVER));
                NetworkHandler.sendToDimension(new ServerMessageGunHurt(this.m_19879_(), player.m_19879_(), projectile.getGunId(), damage, isHeadshot, headshotMultiplier), (Entity)this);
            }
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(source);
    }

    public boolean canBeRidden() {
        return false;
    }

    public boolean m_6783_(double distance) {
        double size = this.m_20191_().m_82309_();
        if (Double.isNaN(size)) {
            size = 1.0;
        }
        return distance < (size *= (double)((Integer)RenderConfig.TARGET_RENDER_DISTANCE.get()).intValue() * TargetMinecart.m_20150_()) * size;
    }

    public void m_7617_(DamageSource source) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemStack = new ItemStack((ItemLike)ModItems.TARGET_MINECART.get());
            if (this.m_8077_()) {
                itemStack.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemStack);
        }
    }

    protected Item m_213728_() {
        return (Item)ModItems.TARGET_MINECART.get();
    }

    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.TARGET_MINECART.get());
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    @Nullable
    public GameProfile getGameProfile() {
        if (this.gameProfile == null && this.m_7770_() != null) {
            this.gameProfile = new GameProfile(null, this.m_7770_().getString());
            SkullBlockEntity.m_155738_((GameProfile)this.gameProfile, gameProfile -> {
                this.gameProfile = gameProfile;
            });
        }
        return this.gameProfile;
    }

    @NotNull
    public BlockState m_6390_() {
        return ((Block)ModBlocks.TARGET.get()).m_49966_();
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public float getMaxCartSpeedOnRail() {
        return 0.2f;
    }
}

