/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunReload;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.items.IItemHandler;

public class LivingEntityReload {
    private final LivingEntity shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityReload(LivingEntity shooter, ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void reload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        ItemStack currentGunItem = this.data.currentGunItem.get();
        Item item = currentGunItem.m_41720_();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.boltCoolDown >= 0L) {
                return;
            }
            int currentAmmoCount = iGun.getCurrentAmmoCount(currentGunItem);
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(currentGunItem, gunIndex.getGunData());
            if (IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo() && !LivingEntityReload.inventoryHasAmmo(this.shooter, currentAmmoCount, maxAmmoCount, currentGunItem, iGun)) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new GunReloadEvent(this.shooter, currentGunItem, LogicalSide.SERVER))) {
                return;
            }
            NetworkHandler.sendToTrackingEntity(new ServerMessageGunReload(this.shooter.m_19879_(), currentGunItem), (Entity)this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = iGun.getCurrentAmmoCount(currentGunItem) + (iGun.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            this.data.reloadStateType = ammoCount <= 0 ? ReloadState.StateType.EMPTY_RELOAD_FEEDING : ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
            this.data.reloadTimestamp = System.currentTimeMillis();
        });
    }

    public ReloadState tickReloadState() {
        AbstractGunItem abstractGunItem;
        ReloadState reloadState = new ReloadState();
        reloadState.setStateType(ReloadState.StateType.NOT_RELOADING);
        reloadState.setCountDown(-1L);
        if (this.data.reloadTimestamp == -1L || this.data.currentGunItem == null) {
            return reloadState;
        }
        Item item = this.data.currentGunItem.get().m_41720_();
        if (!(item instanceof IGun)) {
            return reloadState;
        }
        IGun iGun = (IGun)item;
        ItemStack currentGunItem = this.data.currentGunItem.get();
        ResourceLocation gunId = iGun.getGunId(currentGunItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        if (gunIndexOptional.isEmpty()) {
            return reloadState;
        }
        GunData gunData = gunIndexOptional.get().getGunData();
        GunReloadData reloadData = gunData.getReloadData();
        long countDown = -1L;
        ReloadState.StateType stateType = this.data.reloadStateType;
        long progressTime = System.currentTimeMillis() - this.data.reloadTimestamp;
        if (stateType.isReloadingEmpty()) {
            feedTime = (long)(reloadData.getFeed().getEmptyTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getEmptyTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.EMPTY_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        } else if (stateType.isReloadingTactical()) {
            feedTime = (long)(reloadData.getFeed().getTacticalTime() * 1000.0f);
            long finishingTime = (long)(reloadData.getCooldown().getTacticalTime() * 1000.0f);
            if (progressTime < feedTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
                countDown = feedTime - progressTime;
            } else if (progressTime < finishingTime) {
                stateType = ReloadState.StateType.TACTICAL_RELOAD_FINISHING;
                countDown = finishingTime - progressTime;
            } else {
                stateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        }
        int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(currentGunItem, gunData);
        if (this.data.reloadStateType == ReloadState.StateType.EMPTY_RELOAD_FEEDING && stateType == ReloadState.StateType.EMPTY_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.reloadAmmo(currentGunItem, LivingEntityReload.getAndExtractNeedAmmoCount(this.shooter, this.data.currentGunItem.get(), iGun, maxAmmoCount), true);
            }
        }
        if (this.data.reloadStateType == ReloadState.StateType.TACTICAL_RELOAD_FEEDING && stateType == ReloadState.StateType.TACTICAL_RELOAD_FINISHING && iGun instanceof AbstractGunItem) {
            abstractGunItem = (AbstractGunItem)iGun;
            if (this.data.currentGunItem != null) {
                abstractGunItem.reloadAmmo(currentGunItem, LivingEntityReload.getAndExtractNeedAmmoCount(this.shooter, this.data.currentGunItem.get(), iGun, maxAmmoCount), false);
            }
        }
        this.data.reloadStateType = stateType;
        reloadState.setStateType(stateType);
        reloadState.setCountDown(countDown);
        return reloadState;
    }

    public static boolean inventoryHasAmmo(LivingEntity shooter, int currentAmmoCount, int maxAmmoCount, ItemStack currentGunItem, IGun iGun) {
        if (currentAmmoCount >= maxAmmoCount) {
            return false;
        }
        if (iGun.useDummyAmmo(currentGunItem)) {
            return iGun.getDummyAmmoAmount(currentGunItem) > 0;
        }
        return shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> {
            for (int i = 0; i < cap.getSlots(); ++i) {
                IAmmoBox iAmmoBox;
                IAmmo iAmmo;
                ItemStack checkAmmoStack = cap.getStackInSlot(i);
                Item patt8350$temp = checkAmmoStack.m_41720_();
                if (patt8350$temp instanceof IAmmo && (iAmmo = (IAmmo)patt8350$temp).isAmmoOfGun(currentGunItem, checkAmmoStack)) {
                    return true;
                }
                Item patt8525$temp = checkAmmoStack.m_41720_();
                if (!(patt8525$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt8525$temp).isAmmoBoxOfGun(currentGunItem, checkAmmoStack)) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public static int getAndExtractNeedAmmoCount(LivingEntity shooter, ItemStack currentGunItem, IGun iGun, int maxAmmoCount) {
        int currentAmmoCount = iGun.getCurrentAmmoCount(currentGunItem);
        if (IGunOperator.fromLivingEntity(shooter).needCheckAmmo()) {
            if (iGun.useDummyAmmo(currentGunItem)) {
                return LivingEntityReload.getAndExtractDummyAmmoCount(maxAmmoCount, currentAmmoCount, currentGunItem, iGun);
            }
            return shooter.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(cap -> LivingEntityReload.getAndExtractInventoryAmmoCount(cap, maxAmmoCount, currentAmmoCount, currentGunItem)).orElse(currentAmmoCount);
        }
        return maxAmmoCount;
    }

    private static int getAndExtractDummyAmmoCount(int maxAmmoCount, int currentAmmoCount, ItemStack currentGunItem, IGun iGun) {
        int needAmmoCount = maxAmmoCount - currentAmmoCount;
        int dummyAmmoCount = iGun.getDummyAmmoAmount(currentGunItem);
        int extractCount = Math.min(dummyAmmoCount, needAmmoCount);
        iGun.setDummyAmmoAmount(currentGunItem, dummyAmmoCount - extractCount);
        return maxAmmoCount - (needAmmoCount - extractCount);
    }

    private static int getAndExtractInventoryAmmoCount(IItemHandler itemHandler, int maxAmmoCount, int currentAmmoCount, ItemStack currentGunItem) {
        Item extractItem;
        IAmmo iAmmo;
        ItemStack checkAmmoStack;
        Item item;
        int needAmmoCount = maxAmmoCount - currentAmmoCount;
        for (int i = 0; !(i >= itemHandler.getSlots() || (item = (checkAmmoStack = itemHandler.getStackInSlot(i)).m_41720_()) instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(currentGunItem, checkAmmoStack) && (needAmmoCount -= (extractItem = itemHandler.extractItem(i, needAmmoCount, false)).m_41613_()) <= 0); ++i) {
            IAmmoBox iAmmoBox;
            extractItem = checkAmmoStack.m_41720_();
            if (!(extractItem instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)extractItem).isAmmoBoxOfGun(currentGunItem, checkAmmoStack)) continue;
            int boxAmmoCount = iAmmoBox.getAmmoCount(checkAmmoStack);
            int extractCount = Math.min(boxAmmoCount, needAmmoCount);
            int remainCount = boxAmmoCount - extractCount;
            iAmmoBox.setAmmoCount(checkAmmoStack, remainCount);
            if (remainCount <= 0) {
                iAmmoBox.setAmmoId(checkAmmoStack, DefaultAssets.EMPTY_AMMO_ID);
            }
            if ((needAmmoCount -= extractCount) <= 0) break;
        }
        return maxAmmoCount - needAmmoCount;
    }
}

