/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.mixin.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.ZoomConfig;
import com.tacz.guns.util.math.MathUtil;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    @WrapOperation(method={"turnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;turn(DD)V")})
    public void reduceSensitivity(LocalPlayer player, double yaw, double pitch, Operation<Void> original) {
        ItemStack mainHandItem = player.m_21205_();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            original.call(new Object[]{player, yaw, pitch});
            return;
        }
        ResourceLocation attachmentId = iGun.getAttachmentId(mainHandItem, AttachmentType.SCOPE);
        float zoomLevel = 1.0f;
        if (DefaultAssets.isEmptyAttachmentId(attachmentId)) {
            ResourceLocation gunId = iGun.getGunId(mainHandItem);
            zoomLevel = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getIronZoom).orElse(Float.valueOf(1.0f)).floatValue();
        } else {
            float[] zoom;
            Optional<ClientAttachmentIndex> optional = TimelessAPI.getClientAttachmentIndex(attachmentId);
            if (optional.isPresent() && (zoom = optional.get().getZoom()) != null && zoom.length > 0) {
                CompoundTag attachmentTag = iGun.getAttachmentTag(mainHandItem, AttachmentType.SCOPE);
                zoomLevel = zoom[AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag) % zoom.length];
            }
        }
        Minecraft minecraft = Minecraft.m_91087_();
        float progress = IGunOperator.fromLivingEntity((LivingEntity)player).getSynAimingProgress();
        double sensitivityMultiplier = (Double)ZoomConfig.ZOOM_SENSITIVITY_BASE_MULTIPLIER.get();
        sensitivityMultiplier = 1.0 + (sensitivityMultiplier - 1.0) * (double)progress;
        double originalFov = ((Integer)minecraft.f_91066_.m_231837_().m_231551_()).intValue();
        double currentFov = MathUtil.magnificationToFov(1.0f + (zoomLevel - 1.0f) * progress, originalFov);
        double coefficient = (Double)ZoomConfig.SCREEN_DISTANCE_COEFFICIENT.get();
        double denominator = MathUtil.zoomSensitivityRatio(currentFov, originalFov, coefficient) * sensitivityMultiplier;
        original.call(new Object[]{player, yaw * denominator, pitch * denominator});
    }
}

