/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message.event;

import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class ServerMessageGunKill {
    private final int killEntityId;
    private final int attackerId;
    private final ResourceLocation gunId;
    private final boolean isHeadShot;

    public ServerMessageGunKill(int killEntityId, int attackerId, ResourceLocation gunId, boolean isHeadShot) {
        this.killEntityId = killEntityId;
        this.attackerId = attackerId;
        this.gunId = gunId;
        this.isHeadShot = isHeadShot;
    }

    public static void encode(ServerMessageGunKill message, FriendlyByteBuf buf) {
        buf.writeInt(message.killEntityId);
        buf.writeInt(message.attackerId);
        buf.m_130085_(message.gunId);
        buf.writeBoolean(message.isHeadShot);
    }

    public static ServerMessageGunKill decode(FriendlyByteBuf buf) {
        int killEntityId = buf.readInt();
        int attackerId = buf.readInt();
        ResourceLocation gunId = buf.m_130281_();
        boolean isHeadShot = buf.readBoolean();
        return new ServerMessageGunKill(killEntityId, attackerId, gunId, isHeadShot);
    }

    public static void handle(ServerMessageGunKill message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> ServerMessageGunKill.onKill(message));
        }
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onKill(ServerMessageGunKill message) {
        LivingEntity livingEntity;
        LivingEntity livingEntity2;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = level.m_6815_(message.killEntityId);
        LivingEntity killedEntity = entity instanceof LivingEntity ? (livingEntity2 = (LivingEntity)entity) : null;
        Entity entity2 = level.m_6815_(message.attackerId);
        LivingEntity attacker = entity2 instanceof LivingEntity ? (livingEntity = (LivingEntity)entity2) : null;
        MinecraftForge.EVENT_BUS.post((Event)new EntityKillByGunEvent(killedEntity, attacker, message.gunId, message.isHeadShot, LogicalSide.CLIENT));
    }
}

