/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.pojo.data.gun;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.BurstData;
import com.tacz.guns.resource.pojo.data.gun.GunMeleeData;
import com.tacz.guns.resource.pojo.data.gun.GunRecoil;
import com.tacz.guns.resource.pojo.data.gun.GunReloadData;
import com.tacz.guns.resource.pojo.data.gun.InaccuracyType;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GunData {
    @SerializedName(value="ammo")
    private ResourceLocation ammoId = null;
    @SerializedName(value="ammo_amount")
    private int ammoAmount = 30;
    @SerializedName(value="extended_mag_ammo_amount")
    private int @Nullable [] extendedMagAmmoAmount = null;
    @SerializedName(value="bolt")
    private Bolt bolt = Bolt.OPEN_BOLT;
    @SerializedName(value="rpm")
    private int roundsPerMinute = 300;
    @SerializedName(value="bullet")
    private BulletData bulletData = new BulletData();
    @SerializedName(value="draw_time")
    private float drawTime = 0.4f;
    @SerializedName(value="put_away_time")
    private float putAwayTime = 0.4f;
    @SerializedName(value="sprint_time")
    private float sprintTime = 0.2f;
    @SerializedName(value="aim_time")
    private float aimTime = 0.2f;
    @SerializedName(value="bolt_action_time")
    private float boltActionTime = 0.0f;
    @SerializedName(value="reload")
    private GunReloadData reloadData = new GunReloadData();
    @SerializedName(value="fire_mode")
    private List<FireMode> fireModeSet = Collections.singletonList(FireMode.UNKNOWN);
    @SerializedName(value="burst_data")
    private BurstData burstData = new BurstData();
    @SerializedName(value="recoil")
    private GunRecoil recoil = new GunRecoil();
    @SerializedName(value="hurt_bob_tweak_multiplier")
    private float hurtBobTweakMultiplier = 0.05f;
    @SerializedName(value="inaccuracy")
    private Map<InaccuracyType, Float> inaccuracy = null;
    @SerializedName(value="move_speed")
    private MoveSpeed moveSpeed = new MoveSpeed();
    @SerializedName(value="melee")
    private GunMeleeData gunMeleeData = new GunMeleeData();
    @SerializedName(value="allow_attachment_types")
    private List<AttachmentType> allowAttachments = Lists.newArrayList();
    @SerializedName(value="exclusive_attachments")
    private Map<ResourceLocation, AttachmentData> exclusiveAttachments = Maps.newHashMap();

    public ResourceLocation getAmmoId() {
        return this.ammoId;
    }

    public int getAmmoAmount() {
        return this.ammoAmount;
    }

    public int @Nullable [] getExtendedMagAmmoAmount() {
        return this.extendedMagAmmoAmount;
    }

    public Bolt getBolt() {
        return this.bolt;
    }

    public int getRoundsPerMinute() {
        return this.roundsPerMinute;
    }

    public BulletData getBulletData() {
        return this.bulletData;
    }

    public float getDrawTime() {
        return this.drawTime;
    }

    public float getPutAwayTime() {
        return this.putAwayTime;
    }

    public float getAimTime() {
        return this.aimTime;
    }

    public float getSprintTime() {
        return this.sprintTime;
    }

    public float getBoltActionTime() {
        return this.boltActionTime;
    }

    public GunReloadData getReloadData() {
        return this.reloadData;
    }

    public List<FireMode> getFireModeSet() {
        return this.fireModeSet;
    }

    public BurstData getBurstData() {
        return this.burstData;
    }

    public GunRecoil getRecoil() {
        return this.recoil;
    }

    public float getHurtBobTweakMultiplier() {
        return this.hurtBobTweakMultiplier;
    }

    public Map<InaccuracyType, Float> getInaccuracy() {
        return this.inaccuracy;
    }

    public void setInaccuracy(Map<InaccuracyType, Float> inaccuracy) {
        this.inaccuracy = inaccuracy;
    }

    public float getInaccuracy(InaccuracyType type) {
        return this.inaccuracy.get((Object)type).floatValue();
    }

    public MoveSpeed getMoveSpeed() {
        return this.moveSpeed;
    }

    public GunMeleeData getMeleeData() {
        return this.gunMeleeData;
    }

    @Nullable
    public List<AttachmentType> getAllowAttachments() {
        return this.allowAttachments;
    }

    public Map<ResourceLocation, AttachmentData> getExclusiveAttachments() {
        return this.exclusiveAttachments;
    }

    public long getShootInterval() {
        if (this.roundsPerMinute <= 0) {
            return 300L;
        }
        return 60000L / (long)this.roundsPerMinute;
    }

    public long getBurstShootInterval() {
        if (this.burstData == null || this.burstData.getBpm() <= 0) {
            return 300L;
        }
        return 60000L / (long)this.burstData.getBpm();
    }
}

