/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public final class RenderHelper {
    public static void blit(PoseStack poseStack, float x, float y, float uOffset, float vOffset, float pWidth, float height, float textureWidth, float textureHeight) {
        RenderHelper.blit(poseStack, x, y, pWidth, height, uOffset, vOffset, pWidth, height, textureWidth, textureHeight);
    }

    private static void blit(PoseStack poseStack, float x, float y, float pWidth, float height, float uOffset, float vOffset, float uWidth, float vHeight, float textureWidth, float textureHeight) {
        RenderHelper.innerBlit(poseStack, x, x + pWidth, y, y + height, 0.0f, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void innerBlit(PoseStack poseStack, float x1, float x2, float y1, float y2, float blitOffset, float uWidth, float vHeight, float uOffset, float vOffset, float textureWidth, float textureHeight) {
        RenderHelper.innerBlit(poseStack.m_85850_().m_252922_(), x1, x2, y1, y2, blitOffset, (uOffset + 0.0f) / textureWidth, (uOffset + uWidth) / textureWidth, (vOffset + 0.0f) / textureHeight, (vOffset + vHeight) / textureHeight);
    }

    private static void innerBlit(Matrix4f matrix, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix, x1, y2, blitOffset).m_7421_(minU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y2, blitOffset).m_7421_(maxU, maxV).m_5752_();
        bufferbuilder.m_252986_(matrix, x2, y1, blitOffset).m_7421_(maxU, minV).m_5752_();
        bufferbuilder.m_252986_(matrix, x1, y1, blitOffset).m_7421_(minU, minV).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void enableItemEntityStencilTest() {
        RenderSystem.assertOnRenderThread();
        Minecraft.m_91087_().m_91385_().enableStencil();
        int depthTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049);
        int stencilTextureId = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36128, (int)36048);
        if (depthTextureId != 0 && stencilTextureId == 0) {
            GL30.glBindTexture((int)3553, (int)depthTextureId);
            int dataType = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)35862);
            if (dataType == 35863) {
                int width = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
                int height = GL30.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
                GlStateManager._texImage2D((int)3553, (int)0, (int)35056, (int)width, (int)height, (int)0, (int)34041, (int)34042, null);
                GlStateManager._glFramebufferTexture2D((int)36160, (int)33306, (int)3553, (int)depthTextureId, (int)0);
            }
        }
        GL11.glEnable((int)2960);
    }

    public static void disableItemEntityStencilTest() {
        RenderSystem.assertOnRenderThread();
        GL11.glDisable((int)2960);
    }

    public static void renderFirstPersonArm(LocalPlayer player, HumanoidArm hand, PoseStack matrixStack, int combinedLight) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher renderManager = mc.m_91290_();
        PlayerRenderer renderer = (PlayerRenderer)renderManager.m_114382_((Entity)player);
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        int oldId = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)player.m_108560_());
        if (hand == HumanoidArm.RIGHT) {
            renderer.m_117770_(matrixStack, (MultiBufferSource)buffer, combinedLight, (AbstractClientPlayer)player);
        } else {
            renderer.m_117813_(matrixStack, (MultiBufferSource)buffer, combinedLight, (AbstractClientPlayer)player);
        }
        RenderSystem.setShaderTexture((int)0, (int)oldId);
    }
}

