/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.configs;

import com.minecraftserverzone.weaponmaster.WeaponMasterMod;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    public final ForgeConfigSpec.BooleanValue[] TOGGLE_SLOT_MODEL = new ForgeConfigSpec.BooleanValue[WeaponMasterMod.maxDisplaySlotNum + 1];
    public final ForgeConfigSpec.BooleanValue CAN_HIDE_ITEMS;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_POS_AND_ROT;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_SCALE;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_ATTACHMENT;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_MOVERS;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_UNIQUE_ITEM_SETTINGS;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_BLACKLIST;
    public final ForgeConfigSpec.BooleanValue CAN_CHANGE_WHITELIST;
    public final ForgeConfigSpec.IntValue hideTick;
    public final ForgeConfigSpec.IntValue[] positions = new ForgeConfigSpec.IntValue[WeaponMasterMod.maxDisplaySlotNum * 3];
    public final ForgeConfigSpec.IntValue[] rotations = new ForgeConfigSpec.IntValue[WeaponMasterMod.maxDisplaySlotNum * 3];
    public final ForgeConfigSpec.ConfigValue<String> slot_attachment;
    public final ForgeConfigSpec.ConfigValue<String> slotMover;
    public final ForgeConfigSpec.ConfigValue<String> blacklist;
    public final ForgeConfigSpec.ConfigValue<String> whitelist;
    public final ForgeConfigSpec.ConfigValue<String> uniqueItemDisplay;
    public final ForgeConfigSpec.IntValue[] scale = new ForgeConfigSpec.IntValue[WeaponMasterMod.maxDisplaySlotNum];

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("model_options");
        this.hideTick = builder.comment("put main and off hand items after x tick to display on the body! 100 tick ~ 5 sec").defineInRange("hidetick", 200, 0, Integer.MAX_VALUE);
        this.uniqueItemDisplay = builder.comment("Put in the name, x,y,z, x-y-z rotation values and the slot where to apply the changes 1-9, shield, banner, offhand! Separate items with a space character").define("uniqueitems", (Object)"name,0,0,0,0,0,0,0,1");
        this.whitelist = builder.comment("Whitelists item that are normally not visible").define("whitelist", (Object)"empty,totem_of_undying");
        this.blacklist = builder.comment("Blacklists item that are normally visible").define("blacklist", (Object)"empty");
        this.TOGGLE_SLOT_MODEL[0] = builder.comment("Slot 1").define("s1", true);
        this.TOGGLE_SLOT_MODEL[1] = builder.comment("Slot 2").define("s2", true);
        this.TOGGLE_SLOT_MODEL[2] = builder.comment("Slot 3").define("s3", true);
        this.TOGGLE_SLOT_MODEL[3] = builder.comment("Slot 4").define("s4", true);
        this.TOGGLE_SLOT_MODEL[4] = builder.comment("Slot 5").define("s5", true);
        this.TOGGLE_SLOT_MODEL[5] = builder.comment("Slot 6").define("s6", true);
        this.TOGGLE_SLOT_MODEL[6] = builder.comment("Slot 7").define("s7", true);
        this.TOGGLE_SLOT_MODEL[7] = builder.comment("Slot 8").define("s8", true);
        this.TOGGLE_SLOT_MODEL[8] = builder.comment("Slot 9").define("s9", true);
        this.TOGGLE_SLOT_MODEL[9] = builder.comment("Shield").define("shield", true);
        this.TOGGLE_SLOT_MODEL[10] = builder.comment("Banner").define("banner", true);
        this.TOGGLE_SLOT_MODEL[11] = builder.comment("main hand").define("main_hand", false);
        this.TOGGLE_SLOT_MODEL[12] = builder.comment("off hand").define("off_hand", false);
        this.TOGGLE_SLOT_MODEL[13] = builder.comment("quiver").define("quiver", false);
        this.slot_attachment = builder.comment("Body part attachment to a slot").define("attachment", (Object)"1-body,2-body,3-rleg,4-lleg,5-rleg,6-lleg,7-body,8-body,9-rleg,shield-body,banner-head,offhand-lleg,quiver-body");
        this.slotMover = builder.comment("Which active slot and equipment should move the item model away").define("slot_mover", (Object)"none,chest;z;+_none,chest,1;z;+_none,legs;x;-_none,legs;x;+_none,legs,3;x;-_none,legs,4;x;+_none,chest,legs,1;z;+_none,shield;z;+_none,legs,3,5;x;-_none;z;-_none;z;-_none,legs,4,6;x;+_none;z;+");
        ForgeConfigSpec.IntValue[] scaleLimitForServers = null;
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 0, 0, 0, -2, 0, 0, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 1, 35, 35, 0, 0, 0, 90, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 2, 1, -20, 12, 0, -90, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 3, 32, -20, 12, 0, -90, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 4, 1, -24, 0, 0, -90, -30, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 5, 31, -24, 0, 0, -90, -30, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 6, -13, 34, -1, 0, 0, -35, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 7, 25, 20, 12, 0, 0, 45, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 8, 1, -14, 20, 0, -90, 20, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 9, 0, 0, 0, 0, 0, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 10, 0, 0, 0, 0, 0, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 11, -2, 22, -14, 110, 90, 0, 0);
        this.initPositionsRotations(builder, this.positions, this.rotations, this.scale, scaleLimitForServers, 12, 0, 0, 15, 0, 0, 0, 0);
        this.CAN_HIDE_ITEMS = builder.comment("Players can hide items with the toggle settings").define("canhideitems", true);
        this.CAN_CHANGE_POS_AND_ROT = builder.comment("Players can change the position and rotation of the displayed items").define("can_change_pos_and_rot", true);
        this.CAN_CHANGE_ATTACHMENT = builder.comment("Players can change the attachment of the slots").define("can_change_attachment", true);
        this.CAN_CHANGE_MOVERS = builder.comment("Players can change the movers of the slots").define("can_change_movers", true);
        this.CAN_CHANGE_UNIQUE_ITEM_SETTINGS = builder.comment("Players can change their unique item settings").define("can_change_uit", true);
        this.CAN_CHANGE_SCALE = builder.comment("Players can change their items scale settings").define("can_change_scale", true);
        this.CAN_CHANGE_BLACKLIST = builder.comment("Players can change their blacklist").define("can_change_scale", true);
        this.CAN_CHANGE_WHITELIST = builder.comment("Players can change their whitelist").define("can_change_scale", true);
        builder.pop();
    }

    public void initPositionsRotations(ForgeConfigSpec.Builder builder, ForgeConfigSpec.IntValue[] pos, ForgeConfigSpec.IntValue[] rot, ForgeConfigSpec.IntValue[] scale, ForgeConfigSpec.IntValue[] scaleLimitForServers, int i, int xpos, int ypos, int zpos, int xrot, int yrot, int zrot, int defaultscale) {
        builder.push("positions_rotations").comment("Position and rotation settings");
        pos[i * 3] = builder.comment("x position" + String.valueOf(i * 3)).defineInRange("x_position" + String.valueOf(i * 3), xpos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        pos[i * 3 + 1] = builder.comment("y position" + String.valueOf(i * 3 + 1)).defineInRange("y_position" + String.valueOf(i * 3 + 1), ypos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        pos[i * 3 + 2] = builder.comment("z position" + String.valueOf(i * 3 + 2)).defineInRange("z_position" + String.valueOf(i * 3 + 2), zpos, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3] = builder.comment("x rotation" + String.valueOf(i * 3)).defineInRange("x_rotation" + String.valueOf(i * 3), xrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3 + 1] = builder.comment("y rotation" + String.valueOf(i * 3 + 1)).defineInRange("y_rotation" + String.valueOf(i * 3 + 1), yrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        rot[i * 3 + 2] = builder.comment("z rotation" + String.valueOf(i * 3 + 2)).defineInRange("z_rotationn" + String.valueOf(i * 3 + 2), zrot, Integer.MIN_VALUE, Integer.MAX_VALUE);
        scale[i] = builder.comment("scale" + String.valueOf(i)).defineInRange("scale" + String.valueOf(i), defaultscale, -100, Integer.MAX_VALUE);
        builder.pop();
    }
}

