/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Optional;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.blockentities.KeypadChestBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.Event;

public class KeypadChestBlock
extends ChestBlock
implements IOverlayDisplay,
IDisguisable {
    private static final DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>> CONTAINER_MERGER = new DoubleBlockCombiner.Combiner<ChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(final ChestBlockEntity chest1, final ChestBlockEntity chest2) {
            CompoundContainer chestInventory = new CompoundContainer((Container)chest1, (Container)chest2);
            return Optional.of(new MenuProvider(){
                final /* synthetic */ Container val$chestInventory;
                {
                    this.val$chestInventory = container;
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    if (chest1.m_7525_(player) && chest2.m_7525_(player)) {
                        chest1.m_59640_(inventory.f_35978_);
                        chest2.m_59640_(inventory.f_35978_);
                        return ChestMenu.m_39246_((int)id, (Inventory)inventory, (Container)this.val$chestInventory);
                    }
                    return null;
                }

                public Component m_5446_() {
                    if (((KeypadChestBlockEntity)chest1).isModuleEnabled(ModuleType.DISGUISE)) {
                        return Utils.localize(IDisguisable.getDisguisedStateOrDefault((BlockEntity)chest1, chest1.m_58900_(), (BlockGetter)chest1.m_58904_(), chest1.m_58899_()).m_60734_().m_7705_(), new Object[0]);
                    }
                    if (chest1.m_8077_()) {
                        return chest1.m_5446_();
                    }
                    return chest2.m_8077_() ? chest2.m_5446_() : Utils.localize("block.securitycraft.keypad_chest_double", new Object[0]);
                }
            });
        }

        public Optional<MenuProvider> acceptSingle(ChestBlockEntity be) {
            return Optional.of(be);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };
    private final float destroyTimeForOwner = OwnableBlock.getStoredDestroyTime();

    public KeypadChestBlock(BlockBehaviour.Properties properties) {
        super(OwnableBlock.withReinforcedDestroyTime(properties), SCContent.KEYPAD_CHEST_BLOCK_ENTITY);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return BlockUtils.getDestroyProgress((x$0, x$1, x$2, x$3) -> super.m_5880_(x$0, x$1, x$2, x$3), this.destroyTimeForOwner, state, player, level, pos);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return (Boolean)ConfigHandler.SERVER.alwaysDrop.get() != false || super.canHarvestBlock(state, level, pos, player);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        KeypadChestBlockEntity be;
        if (!level.f_46443_ && !KeypadChestBlock.isBlocked(level, pos) && (be = (KeypadChestBlockEntity)level.m_7702_(pos)).verifyPasscodeSet(level, pos, be, player)) {
            if (be.isDenied((Entity)player)) {
                if (be.sendsDenylistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                }
            } else if (be.isAllowed((Entity)player)) {
                if (be.sendsAllowlistMessage()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                }
                this.activate(state, level, pos, player);
            } else if (!player.m_21120_(hand).m_150930_((Item)SCContent.CODEBREAKER.get())) {
                be.openPasscodeGUI(level, pos, player);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, Player player) {
        ChestBlock block;
        MenuProvider menuProvider;
        if (!level.f_46443_ && (menuProvider = (block = (ChestBlock)state.m_60734_()).m_7246_(state, level, pos)) != null) {
            player.m_5893_(menuProvider);
            player.m_36246_(Stats.f_12988_.m_12902_((Object)Stats.f_12968_));
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        super.m_6402_(level, pos, state, entity, stack);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
            if (state.m_61143_((Property)f_51479_) != ChestType.SINGLE) {
                KeypadChestBlockEntity thisBe = (KeypadChestBlockEntity)level.m_7702_(pos);
                BlockEntity otherBe = level.m_7702_(pos.m_121945_(KeypadChestBlock.m_51584_((BlockState)state)));
                if (otherBe instanceof KeypadChestBlockEntity) {
                    KeypadChestBlockEntity be = (KeypadChestBlockEntity)otherBe;
                    if (thisBe.getOwner().owns(be)) {
                        for (ModuleType type : be.getInsertedModules()) {
                            thisBe.insertModule(be.getModule(type), false);
                        }
                        thisBe.readOptions(be.writeOptions(new CompoundTag()));
                        if (be.getSaltKey() != null) {
                            thisBe.setSaltKey(SaltData.copySaltToNewKey(be.getSaltKey()));
                        }
                        thisBe.setPasscode(be.getPasscode());
                    }
                }
            }
        }
    }

    public Direction m_51494_(BlockPlaceContext ctx, Direction dir) {
        IOwnable ownable;
        BlockEntity blockEntity;
        Direction returnValue = super.m_51494_(ctx, dir);
        if (returnValue != null && (blockEntity = ctx.m_43725_().m_7702_(ctx.m_8083_().m_121945_(dir))) instanceof IOwnable && (ownable = (IOwnable)blockEntity).isOwnedBy((Entity)ctx.m_43723_())) {
            return returnValue;
        }
        return null;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
            return be.isModuleEnabled(ModuleType.REDSTONE) ? Mth.m_14045_((int)be.getNumPlayersUsing(), (int)0, (int)15) : 0;
        }
        return 0;
    }

    public int m_6376_(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return side == Direction.UP ? state.m_60746_(level, pos, side) : 0;
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof KeypadChestBlockEntity) {
            KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
            be.m_155250_(state);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof IPasscodeProtected) {
            IPasscodeProtected be = (IPasscodeProtected)blockEntity;
            SaltData.removeSalt(be.getSaltKey());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        return ((Optional)this.m_5641_(state, level, pos, false).m_5649_(CONTAINER_MERGER)).orElse(null);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new KeypadChestBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? KeypadChestBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get()), ChestBlockEntity::m_155343_) : null;
    }

    public static boolean isBlocked(Level level, BlockPos pos) {
        return KeypadChestBlock.isBelowSolidBlock(level, pos);
    }

    private static boolean isBelowSolidBlock(Level level, BlockPos pos) {
        return level.m_8055_(pos.m_7494_()).m_60796_((BlockGetter)level, pos.m_7494_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_51478_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_51478_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)f_51478_)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60651_(level, pos, ctx);
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getLightEmission(level, pos);
        }
        return super.getLightEmission(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.getSoundType(level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float m_7749_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60792_(level, pos);
        }
        return super.m_7749_(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.m_60734_() != this) {
            return disguisedState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public BlockState getAppearance(BlockState state, BlockAndTintGetter level, BlockPos pos, Direction side, BlockState queryState, BlockPos queryPos) {
        return IDisguisable.getDisguisedStateOrDefault(state, (BlockGetter)level, pos);
    }

    @Override
    public ItemStack getDisplayStack(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos);
    }

    @Override
    public boolean shouldShowSCInfo(Level level, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((BlockGetter)level, pos).m_41720_() == this.m_5456_();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (IDisguisable.shouldPickBlockDisguise(level, pos, player)) {
            return this.getDisguisedStack(level, pos);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.m_204336_(Tags.Blocks.CHESTS_WOODEN);
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.m_60713_((Block)SCContent.KEYPAD_CHEST.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            this.convert(player, level, pos, true);
            return true;
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            this.convert(player, level, pos, false);
            return true;
        }

        @Override
        public int getRequiredKeyPanels(BlockState state) {
            return state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE ? 2 : 1;
        }

        private void convert(Player player, Level level, BlockPos pos, boolean protect) {
            BlockState state = level.m_8055_(pos);
            Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
            ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
            ChestBlockEntity chest = (ChestBlockEntity)level.m_7702_(pos);
            if (!protect) {
                ((IModuleInventory)chest).dropAllModules();
            }
            this.convertSingleChest(chest, player, level, pos, state, facing, type, protect);
            if (type != ChestType.SINGLE) {
                BlockPos newPos = pos.m_121945_(ChestBlock.m_51584_((BlockState)state));
                BlockState newState = level.m_8055_(newPos);
                this.convertSingleChest((ChestBlockEntity)level.m_7702_(newPos), player, level, newPos, newState, facing, type.m_61486_(), protect);
            }
        }

        private void convertSingleChest(ChestBlockEntity chest, Player player, Level level, BlockPos pos, BlockState oldChestState, Direction facing, ChestType type, boolean protect) {
            Block convertedBlock;
            if (protect) {
                convertedBlock = (Block)SCContent.KEYPAD_CHEST.get();
            } else {
                convertedBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(((KeypadChestBlockEntity)chest).getPreviousChest());
                if (convertedBlock == Blocks.f_50016_) {
                    convertedBlock = Blocks.f_50087_;
                }
            }
            chest.m_59640_(player);
            CompoundTag tag = chest.m_187480_();
            chest.m_6211_();
            level.m_46597_(pos, (BlockState)((BlockState)convertedBlock.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)facing)).m_61124_((Property)ChestBlock.f_51479_, (Comparable)type));
            chest = (ChestBlockEntity)level.m_7702_(pos);
            chest.m_142466_(tag);
            if (protect) {
                if (player != null) {
                    ((IOwnable)chest).setOwner(player.m_20148_().toString(), player.m_7755_().getString());
                }
                ((KeypadChestBlockEntity)chest).setPreviousChest(oldChestState.m_60734_());
            }
        }
    }
}

