/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;

public class CameraViewAreaExtension {
    private static final Long2ObjectOpenHashMap<ChunkRenderDispatcher.RenderChunk> SECTIONS = new Long2ObjectOpenHashMap();
    private static ChunkRenderDispatcher chunkRenderDispatcher;
    private static int minSectionY;
    private static int maxSectionY;

    private CameraViewAreaExtension() {
    }

    public static void allChanged(ChunkRenderDispatcher newFactory, Level level) {
        chunkRenderDispatcher = newFactory;
        minSectionY = level.m_151560_();
        maxSectionY = level.m_151561_();
    }

    public static ChunkRenderDispatcher.RenderChunk provideSection(long sectionPos) {
        return (ChunkRenderDispatcher.RenderChunk)SECTIONS.computeIfAbsent(sectionPos, CameraViewAreaExtension::createSection);
    }

    private static ChunkRenderDispatcher.RenderChunk createSection(long sectionPos) {
        BlockPos sectionOrigin = SectionPos.m_123184_((long)sectionPos).m_123249_();
        ChunkRenderDispatcher chunkRenderDispatcher = CameraViewAreaExtension.chunkRenderDispatcher;
        Objects.requireNonNull(chunkRenderDispatcher);
        return new ChunkRenderDispatcher.RenderChunk(chunkRenderDispatcher, 0, sectionOrigin.m_123341_(), sectionOrigin.m_123342_(), sectionOrigin.m_123343_());
    }

    public static void setDirty(int cx, int cy, int cz, boolean playerChanged) {
        ChunkRenderDispatcher.RenderChunk section = CameraViewAreaExtension.rawFetch(cx, cy, cz, false);
        if (section != null) {
            section.m_112828_(playerChanged);
        }
    }

    public static void onChunkUnload(int sectionX, int sectionZ) {
        for (int sectionY = minSectionY; sectionY < maxSectionY; ++sectionY) {
            long sectionPos = SectionPos.m_123209_((int)sectionX, (int)sectionY, (int)sectionZ);
            ChunkRenderDispatcher.RenderChunk section = (ChunkRenderDispatcher.RenderChunk)SECTIONS.get(sectionPos);
            if (section == null) continue;
            section.m_112838_();
            SECTIONS.remove(sectionPos);
        }
    }

    public static ChunkRenderDispatcher.RenderChunk rawFetch(int cx, int cy, int cz, boolean generateNew) {
        if (cy < minSectionY || cy >= maxSectionY) {
            return null;
        }
        long sectionPos = SectionPos.m_123209_((int)cx, (int)cy, (int)cz);
        return generateNew ? CameraViewAreaExtension.provideSection(sectionPos) : (ChunkRenderDispatcher.RenderChunk)SECTIONS.get(sectionPos);
    }

    public static void clear() {
        for (ChunkRenderDispatcher.RenderChunk section : SECTIONS.values()) {
            section.m_112838_();
        }
        SECTIONS.clear();
    }

    public static int minSectionY() {
        return minSectionY;
    }

    public static int maxSectionY() {
        return maxSectionY;
    }
}

