/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.CameraNightVisionEffectInstance;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.PacketDistributor;

public class SecurityCamera
extends Entity {
    public static final EntityDataAccessor<Float> ZOOM_AMOUNT = SynchedEntityData.m_135353_(SecurityCamera.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final Map<UUID, BlockPos> DISMOUNTED_PLAYERS = new HashMap<UUID, BlockPos>();
    protected boolean zooming = false;
    private int initialChunkLoadingDistance = 0;
    private boolean hasSentChunks = false;
    private SecurityCameraBlockEntity be;

    public SecurityCamera(EntityType<SecurityCamera> type, Level level) {
        super((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), level);
        this.f_19794_ = true;
    }

    public SecurityCamera(Level level, BlockPos pos) {
        this((EntityType<SecurityCamera>)((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get()), level);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SecurityCameraBlockEntity)) {
            this.m_146870_();
            return;
        }
        SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)blockEntity;
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        this.be = cam;
        if (this.be.isDown()) {
            y += 0.25;
        }
        this.m_6034_(x, y, z);
        this.m_19915_(this.be.getInitialYRotation(), this.be.getInitialXRotation());
        this.setZoomAmount(this.be.getInitialZoom());
    }

    protected boolean m_6093_() {
        return false;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (!level.f_46443_ && level.m_8055_(this.m_20183_()).m_60734_() != SCContent.SECURITY_CAMERA.get()) {
            this.m_146870_();
        }
    }

    public float getZoomAmount() {
        return ((Float)this.f_19804_.m_135370_(ZOOM_AMOUNT)).floatValue();
    }

    public void setZoomAmount(float zoomAmount) {
        this.f_19804_.m_135381_(ZOOM_AMOUNT, (Object)Float.valueOf(zoomAmount));
    }

    public boolean isCameraDown() {
        return this.getBlockEntity() != null && !this.be.m_58901_() && this.be.isDown();
    }

    public void setRotation(float yaw, float pitch) {
        this.m_19915_(yaw, pitch);
    }

    public void setChunkLoadingDistance(int chunkLoadingDistance) {
        this.initialChunkLoadingDistance = chunkLoadingDistance;
    }

    public int getChunkLoadingDistance() {
        return this.initialChunkLoadingDistance;
    }

    public boolean hasSentChunks() {
        return this.hasSentChunks;
    }

    public void setHasSentChunks(boolean hasSentChunks) {
        this.hasSentChunks = hasSentChunks;
    }

    public static boolean hasRecentlyDismounted(ServerPlayer player) {
        return DISMOUNTED_PLAYERS.containsKey(player.m_20148_());
    }

    public static BlockPos fetchRecentDismountLocation(ServerPlayer player) {
        return DISMOUNTED_PLAYERS.remove(player.m_20148_());
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.discardCamera();
    }

    public void stopViewing(ServerPlayer player) {
        if (!this.m_9236_().f_46443_) {
            this.m_146870_();
            player.f_8926_ = player;
            SecurityCraft.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SetCameraView((Entity)player));
            DISMOUNTED_PLAYERS.put(player.m_20148_(), this.m_20183_());
            if (player.m_21124_(MobEffects.f_19611_) instanceof CameraNightVisionEffectInstance) {
                player.m_21195_(MobEffects.f_19611_);
            }
        }
    }

    @Deprecated
    public void discardCamera() {
        if (!this.m_9236_().f_46443_) {
            if (this.getBlockEntity() != null && !this.be.m_58901_()) {
                this.be.stopViewing();
            }
            SectionPos chunkPos = SectionPos.m_123199_((BlockPos)this.m_20183_());
            int chunkLoadingDistance = this.initialChunkLoadingDistance <= 0 ? this.m_9236_().m_7654_().m_6846_().m_11312_() : this.initialChunkLoadingDistance;
            for (int x = chunkPos.m_123341_() - chunkLoadingDistance; x <= chunkPos.m_123341_() + chunkLoadingDistance; ++x) {
                for (int z = chunkPos.m_123343_() - chunkLoadingDistance; z <= chunkPos.m_123343_() + chunkLoadingDistance; ++z) {
                    ForgeChunkManager.forceChunk((ServerLevel)((ServerLevel)this.m_9236_()), (String)"securitycraft", (Entity)this, (int)x, (int)z, (boolean)false, (boolean)false);
                }
            }
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ZOOM_AMOUNT, (Object)Float.valueOf(1.0f));
    }

    public void m_7380_(CompoundTag tag) {
        tag.m_128350_("zoom_amount", this.getZoomAmount());
    }

    public void m_7378_(CompoundTag tag) {
        this.f_19804_.m_135381_(ZOOM_AMOUNT, (Object)Float.valueOf(tag.m_128457_("zoom_amount")));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public boolean m_142389_() {
        return true;
    }

    public SecurityCameraBlockEntity getBlockEntity() {
        if (this.be == null) {
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.m_20183_());
            if (blockEntity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity camera;
                this.be = camera = (SecurityCameraBlockEntity)blockEntity;
            } else {
                SecurityCraft.LOGGER.warn("No security camera block entity was found at {}. Try breaking and replacing the block!", (Object)this.m_20183_());
            }
        }
        return this.be;
    }
}

