/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blocks.SonicSecuritySystemBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SonicSecuritySystemItem
extends BlockItem {
    public SonicSecuritySystemItem(Item.Properties properties) {
        super((Block)SCContent.SONIC_SECURITY_SYSTEM.get(), properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        BlockPos pos;
        BlockEntity be;
        Level level = ctx.m_43725_();
        Player player = ctx.m_43723_();
        if (!level.f_46443_ && !player.m_6144_() && (be = level.m_7702_(pos = ctx.m_8083_())) instanceof ILockable) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy((Entity)player)) {
                if (!(be.m_58900_().m_60734_() instanceof IDisguisable) || !IDisguisable.getDisguisedBlockState(be, (LevelReader)level).isPresent()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", ownable.getOwner().getName()), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (stack.m_41783_() == null) {
                    stack.m_41751_(new CompoundTag());
                }
                if (SonicSecuritySystemItem.isAdded(stack.m_41783_(), pos)) {
                    SonicSecuritySystemItem.removeLinkedBlock(stack.m_41783_(), pos);
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockUnlinked", Utils.localize(level.m_8055_(pos).m_60734_().m_7705_(), new Object[0]), pos), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
                if (SonicSecuritySystemItem.addLinkedBlock(stack.m_41784_(), pos, player)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.blockLinked", Utils.localize(level.m_8055_(pos).m_60734_().m_7705_(), new Object[0]), pos), ChatFormatting.GREEN);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (!stack.m_41782_() || !SonicSecuritySystemItem.hasLinkedBlock(stack.m_41783_())) {
            if (!level.f_46443_) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.notLinked", new Object[0]), ChatFormatting.DARK_RED);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            ClientHandler.displaySSSItemScreen(player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    protected boolean m_7274_(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        SonicSecuritySystemBlockEntity sss;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SonicSecuritySystemBlockEntity && (sss = (SonicSecuritySystemBlockEntity)blockEntity).transferPositionsFromItem(stack.m_41784_())) {
            return true;
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (!stack.m_41782_()) {
            return;
        }
        int numOfLinkedBlocks = stack.m_41783_().m_128437_("LinkedBlocks", 10).size();
        if (numOfLinkedBlocks > 0) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:sonicSecuritySystem.linkedTo", numOfLinkedBlocks).m_130948_(Utils.GRAY_STYLE));
        }
    }

    public static boolean addLinkedBlock(CompoundTag tag, BlockPos pos, Player player) {
        if (SonicSecuritySystemItem.isAdded(tag, pos)) {
            return false;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        if (list.size() >= 30) {
            PlayerUtils.sendMessageToPlayer(player, Utils.localize(((SonicSecuritySystemBlock)SCContent.SONIC_SECURITY_SYSTEM.get()).m_7705_(), new Object[0]), Utils.localize("messages.securitycraft:sonic_security_system.linkMaxReached", 30), ChatFormatting.DARK_RED);
            return false;
        }
        CompoundTag nbt = NbtUtils.m_129224_((BlockPos)pos);
        list.add((Object)nbt);
        tag.m_128365_("LinkedBlocks", (Tag)list);
        return true;
    }

    public static void removeLinkedBlock(CompoundTag tag, BlockPos pos) {
        if (tag == null || !tag.m_128441_("LinkedBlocks")) {
            return;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        for (int i = list.size() - 1; i >= 0; --i) {
            BlockPos posRead = NbtUtils.m_129239_((CompoundTag)list.m_128728_(i));
            if (!pos.equals((Object)posRead)) continue;
            list.remove(i);
        }
    }

    public static boolean isAdded(CompoundTag tag, BlockPos pos) {
        if (tag == null || !tag.m_128441_("LinkedBlocks")) {
            return false;
        }
        ListTag list = tag.m_128437_("LinkedBlocks", 10);
        for (int i = 0; i < list.size(); ++i) {
            BlockPos posRead = NbtUtils.m_129239_((CompoundTag)list.m_128728_(i));
            if (!pos.equals((Object)posRead)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLinkedBlock(CompoundTag tag) {
        if (tag == null || !tag.m_128441_("LinkedBlocks")) {
            return false;
        }
        return !tag.m_128437_("LinkedBlocks", 10).isEmpty();
    }

    public static Set<BlockPos> stackTagToBlockPosSet(CompoundTag itemTag) {
        if (itemTag == null || !itemTag.m_128441_("LinkedBlocks")) {
            return Set.of();
        }
        ListTag blocks = itemTag.m_128437_("LinkedBlocks", 10);
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (int i = 0; i < blocks.size(); ++i) {
            positions.add(NbtUtils.m_129239_((CompoundTag)blocks.m_128728_(i)));
        }
        return positions;
    }
}

