/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.CageTrapBlock;
import net.geforcemods.securitycraft.blocks.InventoryScannerBlock;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.SpecialDoorBlock;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedDoorBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.util.IBlockMine;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class UniversalBlockRemoverItem
extends Item {
    private static final Component DISABLED_ITEM_TOOLTIP = Component.m_237115_((String)"tooltip.securitycraft:universal_block_remover.disabled").m_130940_(ChatFormatting.RED);

    public UniversalBlockRemoverItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext ctx) {
        if (!((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
            Level level = ctx.m_43725_();
            BlockPos pos = ctx.m_8083_();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            BlockEntity be = level.m_7702_(pos);
            Player player = ctx.m_43723_();
            if (be != null && UniversalBlockRemoverItem.isOwnableBlock(block, be)) {
                boolean isDefault;
                DisplayCaseBlockEntity displayCase;
                if (be instanceof DisplayCaseBlockEntity && (displayCase = (DisplayCaseBlockEntity)be).isOpen() && displayCase.getDisplayedStack().m_41619_()) {
                    return InteractionResult.PASS;
                }
                IOwnable ownable = (IOwnable)be;
                Owner owner = ownable.getOwner();
                boolean bl = isDefault = owner.getName().equals("owner") && owner.getUUID().equals("ownerUUID");
                if (!(((Boolean)ConfigHandler.SERVER.allowBreakingNonOwnedBlocks.get()).booleanValue() || isDefault && state.m_60713_((Block)SCContent.FRAME.get()) || ownable.isOwnedBy((Entity)player))) {
                    IDisguisable db;
                    Block block2;
                    if (!(block instanceof IBlockMine || (block2 = be.m_58900_().m_60734_()) instanceof IDisguisable && !(((BlockItem)(db = (IDisguisable)block2).getDisguisedStack((BlockGetter)level, pos).m_41720_()).m_40614_() instanceof IDisguisable))) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.m_5524_(), new Object[0]), Utils.localize("messages.securitycraft:notOwned", PlayerUtils.getOwnerComponent(owner)), ChatFormatting.RED);
                    }
                    return InteractionResult.FAIL;
                }
                if (be instanceof IModuleInventory) {
                    IModuleInventory inv = (IModuleInventory)be;
                    inv.dropAllModules();
                }
                if (block == SCContent.LASER_BLOCK.get()) {
                    LinkableBlockEntity laser = (LinkableBlockEntity)be;
                    for (ItemStack module : laser.getInventory()) {
                        if (module.m_41619_()) continue;
                        laser.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(((ModuleItem)module.m_41720_()).getModuleType(), false), laser);
                    }
                    if (!level.f_46443_) {
                        level.m_46961_(pos, true);
                        LaserBlock.destroyAdjacentLasers((LevelAccessor)level, pos);
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                    }
                } else if (block == SCContent.CAGE_TRAP.get()) {
                    if (!level.f_46443_) {
                        CageTrapBlock.disassembleIronBars(state, level, pos, owner);
                        level.m_46961_(pos, true);
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                    }
                } else {
                    InventoryScannerBlockEntity inventoryScanner;
                    if ((block instanceof ReinforcedDoorBlock || block instanceof SpecialDoorBlock) && state.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                        pos = pos.m_7495_();
                    }
                    if (block == SCContent.INVENTORY_SCANNER.get() && (inventoryScanner = InventoryScannerBlock.getConnectedInventoryScanner(level, pos)) != null) {
                        inventoryScanner.getInventory().clear();
                    }
                    if (!level.f_46443_) {
                        level.m_46961_(pos, true);
                        block.m_6786_((LevelAccessor)level, pos, state);
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(ctx.m_43724_()));
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (((Boolean)ConfigHandler.SERVER.vanillaToolBlockBreaking.get()).booleanValue()) {
            tooltipComponents.add(DISABLED_ITEM_TOOLTIP);
        }
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
    }

    private static boolean isOwnableBlock(Block block, BlockEntity be) {
        return be instanceof OwnableBlockEntity || be instanceof IOwnable || block instanceof OwnableBlock;
    }
}

