/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SecurityCameraModel
extends EntityModel<SecurityCamera> {
    public static final float DEFAULT_X_ROT = 0.2617994f;
    private ModelPart attachment;
    private ModelPart stickTop;
    private ModelPart cameraRotationPoint1;
    public final ModelPart cameraRotationPoint2;

    public SecurityCameraModel(ModelPart modelPart) {
        this.attachment = modelPart.m_171324_("attachment");
        this.stickTop = modelPart.m_171324_("stick_top");
        this.stickTop.f_104203_ = -0.5235988f;
        this.cameraRotationPoint1 = this.setUpRotationPoint(modelPart, "camera_rotation_point_1", "camera_body");
        this.cameraRotationPoint2 = this.setUpRotationPoint(modelPart, "camera_rotation_point_2", "camera_lens");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootDefinition = meshDefinition.m_171576_();
        PartDefinition stickTopDefinition = rootDefinition.m_171599_("stick_top", CubeListBuilder.m_171558_().m_171514_(2, 12).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 6.0f), PartPose.m_171419_((float)-1.0f, (float)13.75f, (float)2.25f));
        PartDefinition cameraRotationPoint1Definition = SecurityCameraModel.defineRotationPoint(rootDefinition, "camera_rotation_point_1");
        PartDefinition cameraRotationPoint2Definition = SecurityCameraModel.defineRotationPoint(rootDefinition, "camera_rotation_point_2");
        PartDefinition cameraBodyDefinition = cameraRotationPoint1Definition.m_171599_("camera_body", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 3.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        rootDefinition.m_171599_("attachment", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 6.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-3.0f, (float)13.0f, (float)7.0f));
        stickTopDefinition.m_171599_("stick_bottom", CubeListBuilder.m_171558_().m_171514_(1, 12).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        cameraBodyDefinition.m_171599_("camera_lens_right", CubeListBuilder.m_171558_().m_171514_(10, 40).m_171481_(-2.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.m_171599_("camera_lens_left", CubeListBuilder.m_171558_().m_171514_(0, 40).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)-3.0f));
        cameraBodyDefinition.m_171599_("camera_lens_top", CubeListBuilder.m_171558_().m_171514_(20, 40).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-1.0f, (float)0.0f, (float)-3.0f));
        cameraRotationPoint2Definition.m_171599_("camera_lens", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-1.99f, 0.01f, -2.01f, 3.98f, 2.98f, 0.01f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-5.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    private static PartDefinition defineRotationPoint(PartDefinition parent, String name) {
        return parent.m_171599_(name, CubeListBuilder.m_171558_().m_171514_(0, 25).m_171481_(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)3.0f));
    }

    public void m_7695_(PoseStack pose, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.attachment.m_104301_(pose, builder, packedLight, packedOverlay);
        this.stickTop.m_104301_(pose, builder, packedLight, packedOverlay);
        this.cameraRotationPoint1.m_104301_(pose, builder, packedLight, packedOverlay);
        this.cameraRotationPoint2.m_104306_(pose, builder, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(SecurityCamera entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void rotateCameraX(float rot) {
        this.cameraRotationPoint1.f_104203_ = rot;
        this.cameraRotationPoint2.f_104203_ = rot;
    }

    public void rotateCameraY(float rot) {
        this.cameraRotationPoint1.f_104204_ = rot;
        this.cameraRotationPoint2.f_104204_ = rot;
    }

    private ModelPart setUpRotationPoint(ModelPart modelPart, String name, String child) {
        ModelPart rotationPoint = modelPart.m_171324_(name);
        rotationPoint.f_104203_ = 0.2617994f;
        rotationPoint.m_171324_((String)child).f_104203_ = 0.2617994f;
        return rotationPoint;
    }
}

