/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.Optional;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncFrame {
    private BlockPos pos;
    private int requestedRenderDistance;
    private Optional<GlobalPos> removedCamera;
    private Optional<GlobalPos> currentCamera;
    boolean disableCurrentCamera;

    public SyncFrame() {
    }

    public SyncFrame(BlockPos pos, int requestedRenderDistance, Optional<GlobalPos> removedCamera, Optional<GlobalPos> currentCamera, boolean disableCurrentCamera) {
        this.pos = pos;
        this.requestedRenderDistance = requestedRenderDistance;
        this.removedCamera = removedCamera;
        this.currentCamera = currentCamera;
        this.disableCurrentCamera = disableCurrentCamera;
    }

    public SyncFrame(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.requestedRenderDistance = buf.m_130242_();
        this.removedCamera = buf.m_236860_(FriendlyByteBuf::m_236872_);
        this.currentCamera = buf.m_236860_(FriendlyByteBuf::m_236872_);
        this.disableCurrentCamera = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130130_(this.requestedRenderDistance);
        buf.m_236835_(this.removedCamera, FriendlyByteBuf::m_236814_);
        buf.m_236835_(this.currentCamera, FriendlyByteBuf::m_236814_);
        buf.writeBoolean(this.disableCurrentCamera);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        BlockEntity blockEntity;
        ServerPlayer player = ctx.get().getSender();
        Level level = player.m_9236_();
        GlobalPos currentCamera = this.currentCamera.orElse(null);
        if (!player.m_5833_() && (blockEntity = level.m_7702_(this.pos)) instanceof FrameBlockEntity) {
            FrameBlockEntity be = (FrameBlockEntity)blockEntity;
            if (be.isDisabled()) {
                return;
            }
            boolean isOwner = be.isOwnedBy((Entity)player);
            if (isOwner) {
                this.removedCamera.ifPresent(be::removeCamera);
            }
            if (isOwner || be.isAllowed((Entity)player)) {
                be.switchCameraOnServer(currentCamera, (Player)player, this.requestedRenderDistance, this.disableCurrentCamera);
            }
        }
    }
}

