/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.network.server.SyncSecureRedstoneInterface;
import net.geforcemods.securitycraft.screen.components.ActiveBasedTextureButton;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SecureRedstoneInterfaceScreen
extends Screen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/secure_redstone_interface.png");
    private static final ResourceLocation RANDOM_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random.png");
    private static final ResourceLocation RANDOM_INACTIVE_TEXTURE = new ResourceLocation("securitycraft", "textures/gui/random_inactive.png");
    private final Component frequencyText = Component.m_237115_((String)"gui.securitycraft:secure_redstone_interface.frequency");
    private final SecureRedstoneInterfaceBlockEntity be;
    private final boolean oldSender;
    private final boolean oldProtectedSignal;
    private final boolean oldSendExactPower;
    private final boolean oldReceiveInvertedPower;
    private final boolean oldHighlightConnections;
    private final int oldFrequency;
    private final int oldSenderRange;
    private final int xSize = 176;
    private final int ySize = 188;
    private int leftPos;
    private int topPos;
    private EditBox frequencyBox;

    public SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        this(be, be.isSender(), be.isProtectedSignal(), be.getFrequency(), be.sendsExactPower(), be.receivesInvertedPower(), be.getSenderRange(), be.shouldHighlightConnections());
    }

    private SecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be, boolean oldSender, boolean oldProtectedSignal, int oldFrequency, boolean oldSendExactPower, boolean oldReceiveInvertedPower, int oldSenderRange, boolean oldHighlightConnections) {
        super(be.m_5446_());
        this.be = be;
        this.oldSender = oldSender;
        this.oldProtectedSignal = oldProtectedSignal;
        this.oldFrequency = oldFrequency;
        this.oldSendExactPower = oldSendExactPower;
        this.oldReceiveInvertedPower = oldReceiveInvertedPower;
        this.oldSenderRange = oldSenderRange;
        this.oldHighlightConnections = oldHighlightConnections;
    }

    protected void m_7856_() {
        int widgetWidth = 150;
        int widgetHeight = 20;
        int row = 0;
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 176) / 2;
        this.topPos = (this.f_96544_ - 188) / 2;
        GridLayout layout = new GridLayout(0, 0);
        GridLayout frequencyLayout = new GridLayout(0, 0);
        String powerSettingKey = "gui.securitycraft:secure_redstone_interface." + (this.be.isSender() ? "send_exact_power" : "receive_inverted_power");
        layout.m_267750_(3);
        frequencyLayout.m_267749_(3);
        this.frequencyBox = new EditBox(this.f_96547_, 0, 0, widgetWidth - 23, widgetHeight, this.frequencyText);
        this.frequencyBox.m_94144_("" + this.be.getFrequency());
        this.frequencyBox.m_94199_(9);
        this.frequencyBox.m_94153_(s -> s.matches("\\d*"));
        this.frequencyBox.m_94151_(s -> {
            if (!s.isEmpty()) {
                this.be.setFrequency(Integer.parseInt(s));
            } else {
                this.be.setFrequency(0);
            }
        });
        frequencyLayout.m_264379_((LayoutElement)this.frequencyBox, 0, 0);
        frequencyLayout.m_264379_((LayoutElement)new ActiveBasedTextureButton(0, 0, 20, widgetHeight, RANDOM_TEXTURE, RANDOM_INACTIVE_TEXTURE, 16, 16, 3, 3, 16, 16, 16, 16, b -> this.frequencyBox.m_94144_("" + SecurityCraft.RANDOM.nextInt(999999999))), 0, 1);
        layout.m_264379_((LayoutElement)frequencyLayout, row++, 0);
        layout.m_264379_((LayoutElement)CycleButton.m_168894_(value -> Component.m_237115_((String)("gui.securitycraft:secure_redstone_interface.mode." + (value != false ? "sender" : "receiver")))).m_168961_((Object[])new Boolean[]{true, false}).m_168948_((Object)this.be.isSender()).m_168936_(0, 0, widgetWidth, widgetHeight, (Component)Component.m_237115_((String)"gui.securitycraft:secure_redstone_interface.mode"), (button, isNowASender) -> {
            this.be.setSender((boolean)isNowASender);
            if (isNowASender.booleanValue()) {
                this.be.setReceiveInvertedPower(this.oldReceiveInvertedPower);
            } else {
                this.be.setProtectedSignal(this.oldProtectedSignal);
                this.be.setSendExactPower(this.oldSendExactPower);
                this.be.setSenderRange(this.oldSenderRange);
            }
            this.f_96541_.m_91152_((Screen)new SecureRedstoneInterfaceScreen(this.be, this.oldSender, this.oldProtectedSignal, this.oldFrequency, this.oldSendExactPower, this.oldReceiveInvertedPower, this.oldSenderRange, this.oldHighlightConnections));
        }), row++, 0);
        layout.m_264379_((LayoutElement)CycleButton.m_168894_(value -> Component.m_237115_((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).m_168961_((Object[])new Boolean[]{true, false}).m_168948_((Object)(this.be.isSender() ? this.be.sendsExactPower() : this.be.receivesInvertedPower())).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)(powerSettingKey + ".tooltip." + value)))).m_168936_(0, 0, widgetWidth, widgetHeight, (Component)Component.m_237115_((String)powerSettingKey), (button, newValue) -> {
            if (this.be.isSender()) {
                this.be.setSendExactPower((boolean)newValue);
            } else {
                this.be.setReceiveInvertedPower((boolean)newValue);
            }
        }), row++, 0);
        if (this.be.isSender()) {
            layout.m_264379_((LayoutElement)CycleButton.m_168894_(value -> Component.m_237115_((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).m_168961_((Object[])new Boolean[]{true, false}).m_168948_((Object)this.be.isProtectedSignal()).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)("gui.securitycraft:secure_redstone_interface.protected_signal.tooltip." + value)))).m_168936_(0, 0, widgetWidth, widgetHeight, (Component)Component.m_237115_((String)"gui.securitycraft:secure_redstone_interface.protected_signal"), (button, newValue) -> this.be.setProtectedSignal((boolean)newValue)), row++, 0);
            layout.m_264379_((LayoutElement)new CallbackSlider(0, 0, widgetWidth, widgetHeight, (Component)Component.m_237110_((String)"gui.securitycraft:projector.range", (Object[])new Object[]{""}), (Component)Component.m_237119_(), 1.0, 64.0, this.be.getSenderRange(), true, slider -> this.be.setSenderRange(slider.getValueInt())), row++, 0);
        }
        layout.m_264379_((LayoutElement)CycleButton.m_168894_(value -> Component.m_237115_((String)("gui.securitycraft:invScan." + (value != false ? "yes" : "no")))).m_168961_((Object[])new Boolean[]{true, false}).m_168948_((Object)this.be.shouldHighlightConnections()).m_232498_(value -> Tooltip.m_257550_((Component)Component.m_237115_((String)"gui.securitycraft:secure_redstone_interface.highlight_connections.tooltip"))).m_168936_(0, 0, widgetWidth, widgetHeight, (Component)Component.m_237115_((String)"gui.securitycraft:secure_redstone_interface.highlight_connections"), (button, newValue) -> this.be.setHighlightConnections((boolean)newValue)), row++, 0);
        layout.m_264036_();
        layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        FrameLayout.m_264159_((LayoutElement)layout, (int)this.leftPos, (int)this.topPos, (int)176, (int)(24 + (this.be.isSender() ? 188 : 142)));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, 176, 188);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int n = this.frequencyBox.m_252754_();
        int n2 = this.frequencyBox.m_252907_();
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280614_(this.f_96547_, this.frequencyText, n, n2 - 9 - 1, 0x404040, false);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.topPos + 6, 0x404040, false);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        super.m_7379_();
        boolean sender = this.be.isSender();
        boolean protectedSignal = this.be.isProtectedSignal();
        int frequency = this.be.getFrequency();
        boolean sendsExactPower = this.be.sendsExactPower();
        boolean receivesInvertedPower = this.be.receivesInvertedPower();
        int senderRange = this.be.getSenderRange();
        boolean highlightConnections = this.be.shouldHighlightConnections();
        if (sender != this.oldSender || protectedSignal != this.oldProtectedSignal || frequency != this.oldFrequency || sendsExactPower != this.oldSendExactPower || receivesInvertedPower != this.oldReceiveInvertedPower || senderRange != this.oldSenderRange || highlightConnections != this.oldHighlightConnections) {
            SecurityCraft.CHANNEL.sendToServer((Object)new SyncSecureRedstoneInterface(this.be.m_58899_(), sender, protectedSignal, frequency, sendsExactPower, receivesInvertedPower, senderRange, highlightConnections));
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

