/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.network.server.RemoveSentryFromSRAT;
import net.geforcemods.securitycraft.network.server.SetSentryMode;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.PacketDistributor;

public class SentryRemoteAccessToolScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft", "textures/gui/container/srat.png");
    private static final ResourceLocation SENTRY_ICONS = new ResourceLocation("securitycraft", "textures/gui/container/sentry_icons.png");
    private final Component modifyAll = Utils.localize("gui.securitycraft:srat.modifyAll", new Object[0]);
    private ItemStack srat;
    private Button[][] guiButtons = new Button[12][3];
    private Button[] guiButtonsGlobal = new Button[3];
    private static final int MODE = 0;
    private static final int TARGETS = 1;
    private static final int UNBIND = 2;
    private int xSize = 440;
    private int ySize = 215;
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();
    private final Component notBound = Utils.localize("gui.securitycraft:srat.notBound", new Object[0]);
    private final Component[] lines = new Component[12];
    private final int[] lengths = new int[12];

    public SentryRemoteAccessToolScreen(ItemStack item) {
        super(item.m_41786_());
        this.srat = item;
    }

    public void m_7856_() {
        super.m_7856_();
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        int paddingX = 22;
        int paddingY = 50;
        int id = 0;
        boolean foundSentry = false;
        int[] modeTextureX = new int[]{0, 16, 32};
        int[] targetTextureX = new int[]{48, 64, 80};
        int[] yStarts = new int[]{0, 0, 0};
        this.hoverCheckers.clear();
        for (int i = 0; i < 12; ++i) {
            int x = i / 6 * this.xSize / 2;
            int y = (i % 6 + 1) * 25 + paddingY;
            int btnY = startY + y - 48;
            BlockPos sentryPos = this.getSentryCoordinates(i);
            for (int j = 0; j < 3; ++j) {
                int btnX = startX + j * paddingX + 147 + x;
                int sentry = id / 3;
                int type = id % 3;
                int index = id++;
                switch (j) {
                    case 0: {
                        this.guiButtons[i][j] = new TogglePictureButton(btnX, btnY, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, b -> this.buttonClicked(b, sentry, type));
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 1: {
                        this.guiButtons[i][j] = new TogglePictureButton(btnX, btnY, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, b -> this.buttonClicked(b, sentry, type));
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    case 2: {
                        this.guiButtons[i][j] = new Button(btnX, btnY, 20, 20, (Component)Component.m_237113_((String)"X"), b -> this.unbindButtonClicked(index), Button.f_252438_);
                        this.guiButtons[i][j].f_93623_ = false;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Sentry actions can only range from 0-2 (inclusive)");
                    }
                }
                this.m_142416_((GuiEventListener)this.guiButtons[i][j]);
            }
            if (sentryPos != null) {
                Sentry sentry;
                List sentries;
                ClientLevel level = this.f_96541_.f_91073_;
                String nameKey = "sentry" + (i + 1) + "_name";
                MutableComponent sentryName = null;
                if (this.srat.m_41782_() && this.srat.m_41783_().m_128441_(nameKey)) {
                    sentryName = Component.m_237113_((String)this.srat.m_41783_().m_128461_(nameKey));
                }
                this.lines[i] = Utils.getFormattedCoordinates(sentryPos);
                this.guiButtons[i][2].f_93623_ = true;
                if (level.m_46749_(sentryPos) && !(sentries = level.m_45976_(Sentry.class, new AABB(sentryPos))).isEmpty() && (sentry = (Sentry)sentries.get(0)).isOwnedBy((Entity)this.f_96541_.f_91074_)) {
                    Sentry.SentryMode mode = sentry.getMode();
                    if (sentryName == null && sentry.m_8077_()) {
                        sentryName = sentry.m_7770_();
                    }
                    this.guiButtons[i][0].f_93623_ = true;
                    this.guiButtons[i][1].f_93623_ = mode != Sentry.SentryMode.IDLE;
                    this.guiButtons[i][2].f_93623_ = true;
                    ((TogglePictureButton)this.guiButtons[i][0]).setCurrentIndex(mode.ordinal() / 3);
                    ((TogglePictureButton)this.guiButtons[i][1]).setCurrentIndex(mode.ordinal() % 3);
                    this.updateModeButtonTooltip(this.guiButtons[i][0]);
                    this.updateTargetsButtonTooltip(this.guiButtons[i][1]);
                    this.guiButtons[i][2].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                    foundSentry = true;
                }
                if (sentryName != null) {
                    int nameWidth = this.f_96547_.m_92852_((FormattedText)sentryName);
                    int nameX = startX + this.xSize / 4 - nameWidth + 33 + i / 6 * this.xSize / 2;
                    TextHoverChecker posTooltipText = new TextHoverChecker(btnY, btnY + 20, nameX, nameX + nameWidth + 2, this.lines[i]);
                    this.lines[i] = sentryName;
                    this.hoverCheckers.add(posTooltipText);
                }
                if (!foundSentry) {
                    for (int j = 0; j < 2; ++j) {
                        this.guiButtons[i][j].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:srat.outOfRange", new Object[0])));
                    }
                    this.guiButtons[i][2].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
                }
            } else {
                this.lines[i] = this.notBound;
            }
            this.lengths[i] = this.f_96547_.m_92852_((FormattedText)this.lines[i]);
        }
        this.guiButtonsGlobal[0] = new TogglePictureButton(startX + 260, startY + 188, 20, 20, SENTRY_ICONS, modeTextureX, yStarts, 2, 3, this::globalModeButtonClicked);
        this.guiButtonsGlobal[1] = new TogglePictureButton(startX + 22 + 260, startY + 188, 20, 20, SENTRY_ICONS, targetTextureX, yStarts, 2, 3, this::globalTargetsButtonClicked);
        this.guiButtonsGlobal[2] = new Button(startX + 44 + 260, startY + 188, 20, 20, (Component)Component.m_237113_((String)"X"), this::globalUnbindButtonClicked, Button.f_252438_);
        for (int j = 0; j < 3; ++j) {
            this.guiButtonsGlobal[j].f_93623_ = foundSentry;
            this.m_142416_((GuiEventListener)this.guiButtonsGlobal[j]);
        }
        this.updateModeButtonTooltip(this.guiButtonsGlobal[0]);
        this.updateTargetsButtonTooltip(this.guiButtonsGlobal[1]);
        this.guiButtonsGlobal[2].m_257544_(Tooltip.m_257550_((Component)Utils.localize("gui.securitycraft:srat.unbind", new Object[0])));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int startX = (this.f_96543_ - this.xSize) / 2;
        int startY = (this.f_96544_ - this.ySize) / 2;
        this.m_280273_(guiGraphics);
        guiGraphics.m_280163_(TEXTURE, startX, startY, 0.0f, 0.0f, this.xSize, this.ySize, 512, 256);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280614_(this.f_96547_, this.f_96539_, startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, startY + 6, 0x404040, false);
        for (int i = 0; i < 12; ++i) {
            guiGraphics.m_280614_(this.f_96547_, this.lines[i], startX + this.xSize / 4 - this.lengths[i] + 35 + i / 6 * this.xSize / 2, startY + i % 6 * 25 + 33, 0x404040, false);
        }
        guiGraphics.m_280614_(this.f_96547_, this.modifyAll, startX + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)this.modifyAll) + 25, startY + 194, 0x404040, false);
        for (TextHoverChecker chc : this.hoverCheckers) {
            if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
            guiGraphics.m_280557_(this.f_96547_, chc.getName(), mouseX, mouseY);
            break;
        }
    }

    protected SetSentryMode.Info performSingleAction(int sentry, int mode, int targets) {
        List sentries;
        BlockPos pos = this.getSentryCoordinates(sentry);
        if (pos != null && !(sentries = Minecraft.m_91087_().f_91074_.m_9236_().m_45976_(Sentry.class, new AABB(pos))).isEmpty()) {
            int resultingMode = Math.max(0, Math.min(targets + mode * 3, 6));
            this.guiButtons[sentry][1].f_93623_ = Sentry.SentryMode.values()[resultingMode] != Sentry.SentryMode.IDLE;
            ((Sentry)sentries.get(0)).toggleMode((Player)Minecraft.m_91087_().f_91074_, resultingMode, false);
            this.updateModeButtonTooltip(this.guiButtons[sentry][0]);
            this.updateTargetsButtonTooltip(this.guiButtons[sentry][1]);
            return new SetSentryMode.Info(((Sentry)sentries.get(0)).m_20183_(), resultingMode);
        }
        return null;
    }

    private void unbindButtonClicked(int id) {
        this.unbindSentry(id / 3);
    }

    private void globalUnbindButtonClicked(Button button) {
        for (int i = 0; i < 12; ++i) {
            this.unbindSentry(i);
        }
    }

    private void unbindSentry(int sentry) {
        int i;
        BlockPos pos = this.getSentryCoordinates(sentry);
        if (pos != null) {
            this.removeTagFromToolAndUpdate(this.srat, pos);
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtons[sentry][i].f_93623_ = false;
            this.guiButtons[sentry][i].m_257544_(null);
        }
        for (i = 0; i < this.guiButtons.length; ++i) {
            if (!this.guiButtons[i][2].f_93623_) continue;
            return;
        }
        for (i = 0; i < 3; ++i) {
            this.guiButtonsGlobal[i].f_93623_ = false;
            this.guiButtonsGlobal[i].m_257544_(null);
        }
    }

    private void buttonClicked(Button button, int sentry, int type) {
        int mode;
        int targets = mode = ((TogglePictureButton)button).getCurrentIndex();
        if (type == 0) {
            targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
        } else if (type == 1) {
            mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
        }
        this.sendUpdates(Arrays.asList(this.performSingleAction(sentry, mode, targets)));
    }

    protected void globalModeButtonClicked(Button button) {
        ArrayList<SetSentryMode.Info> sentriesToUpdate = new ArrayList<SetSentryMode.Info>();
        for (int i = 0; i < this.guiButtons.length; ++i) {
            TogglePictureButton modeButton = (TogglePictureButton)this.guiButtons[i][0];
            if (this.getSentryCoordinates(i) == null) continue;
            int sentry = i;
            int mode = ((TogglePictureButton)button).getCurrentIndex();
            int targets = ((TogglePictureButton)this.guiButtons[sentry][1]).getCurrentIndex();
            modeButton.setCurrentIndex(mode);
            sentriesToUpdate.add(this.performSingleAction(sentry, mode, targets));
        }
        this.sendUpdates(sentriesToUpdate);
        this.updateModeButtonTooltip(this.guiButtonsGlobal[0]);
    }

    protected void globalTargetsButtonClicked(Button button) {
        ArrayList<SetSentryMode.Info> sentriesToUpdate = new ArrayList<SetSentryMode.Info>();
        for (int i = 0; i < this.guiButtons.length; ++i) {
            TogglePictureButton targetsButton = (TogglePictureButton)this.guiButtons[i][1];
            if (this.getSentryCoordinates(i) == null) continue;
            int sentry = i;
            int mode = ((TogglePictureButton)this.guiButtons[sentry][0]).getCurrentIndex();
            int targets = ((TogglePictureButton)button).getCurrentIndex();
            targetsButton.setCurrentIndex(targets);
            sentriesToUpdate.add(this.performSingleAction(sentry, mode, targets));
        }
        this.sendUpdates(sentriesToUpdate);
        this.updateTargetsButtonTooltip(this.guiButtonsGlobal[1]);
    }

    private void sendUpdates(List<SetSentryMode.Info> sentriesToUpdate) {
        SecurityCraft.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new SetSentryMode(sentriesToUpdate));
    }

    private BlockPos getSentryCoordinates(int sentry) {
        int[] coords;
        if (this.srat.m_41720_() == SCContent.SENTRY_REMOTE_ACCESS_TOOL.get() && this.srat.m_41782_() && (coords = this.srat.m_41783_().m_128465_("sentry" + ++sentry)).length == 3) {
            return new BlockPos(coords[0], coords[1], coords[2]);
        }
        return null;
    }

    private void removeTagFromToolAndUpdate(ItemStack stack, BlockPos pos) {
        if (stack.m_41783_() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords = stack.m_41783_().m_128465_("sentry" + i);
            if (coords.length != 3 || coords[0] != pos.m_123341_() || coords[1] != pos.m_123342_() || coords[2] != pos.m_123343_()) continue;
            stack.m_41783_().m_128473_("sentry" + i);
            SecurityCraft.CHANNEL.sendToServer((Object)new RemoveSentryFromSRAT(i));
            return;
        }
    }

    private void updateModeButtonTooltip(Button button) {
        button.m_257544_(Tooltip.m_257550_((Component)(switch (((IToggleableButton)button).getCurrentIndex()) {
            case 0 -> Utils.localize("gui.securitycraft:srat.mode2", new Object[0]);
            case 1 -> Utils.localize("gui.securitycraft:srat.mode1", new Object[0]);
            case 2 -> Utils.localize("gui.securitycraft:srat.mode3", new Object[0]);
            default -> Utils.localize("gui.securitycraft:srat.mode2", new Object[0]);
        })));
    }

    private void updateTargetsButtonTooltip(Button button) {
        button.m_257544_(Tooltip.m_257550_((Component)(switch (((IToggleableButton)button).getCurrentIndex()) {
            case 0 -> Utils.localize("gui.securitycraft:srat.targets1", new Object[0]);
            case 1 -> Utils.localize("gui.securitycraft:srat.targets2", new Object[0]);
            case 2 -> Utils.localize("gui.securitycraft:srat.targets3", new Object[0]);
            default -> Utils.localize("gui.securitycraft:srat.targets1", new Object[0]);
        })));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

