/*
 * Decompiled with CFR 0.152.
 */
package com.armatyrich.taczxgunlightsaddon.server;

import com.armatyrich.taczxgunlightsaddon.BulletLightPerLevel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="taczxgunlightsaddon", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BulletLightSystem {
    private static final Map<ResourceKey<Level>, BulletLightPerLevel> PER_LEVEL = new HashMap<ResourceKey<Level>, BulletLightPerLevel>();
    private static final Map<ResourceKey<Level>, Integer> TICK_COUNTERS = new HashMap<ResourceKey<Level>, Integer>();
    private static final Map<ResourceKey<Level>, Set<UUID>> TRACKED = new HashMap<ResourceKey<Level>, Set<UUID>>();
    private static final Predicate<Entity> IS_TACZ_BULLET = e -> {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_());
        return id != null && "tacz".equals(id.m_135827_()) && id.m_135815_().contains("bullet");
    };

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load e) {
        if (e.getLevel().m_5776_()) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.getLevel();
        PER_LEVEL.put((ResourceKey<Level>)sl.m_46472_(), new BulletLightPerLevel(sl));
        TICK_COUNTERS.put((ResourceKey<Level>)sl.m_46472_(), 0);
        TRACKED.put((ResourceKey<Level>)sl.m_46472_(), new HashSet());
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload e) {
        if (e.getLevel().m_5776_()) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.getLevel();
        BulletLightPerLevel mgr = PER_LEVEL.remove(sl.m_46472_());
        if (mgr != null) {
            mgr.cleanupAll();
        }
        TICK_COUNTERS.remove(sl.m_46472_());
        TRACKED.remove(sl.m_46472_());
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent e) {
        if (e.getLevel().m_5776_()) {
            return;
        }
        if (!IS_TACZ_BULLET.test(e.getEntity())) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.getLevel();
        PER_LEVEL.computeIfAbsent((ResourceKey<Level>)sl.m_46472_(), d -> new BulletLightPerLevel(sl));
        TRACKED.computeIfAbsent((ResourceKey<Level>)sl.m_46472_(), d -> new HashSet()).add(e.getEntity().m_20148_());
    }

    @SubscribeEvent
    public static void onLeave(EntityLeaveLevelEvent e) {
        BulletLightPerLevel mgr;
        if (e.getLevel().m_5776_()) {
            return;
        }
        if (!IS_TACZ_BULLET.test(e.getEntity())) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.getLevel();
        Set<UUID> set = TRACKED.get(sl.m_46472_());
        if (set != null) {
            set.remove(e.getEntity().m_20148_());
        }
        if ((mgr = PER_LEVEL.get(sl.m_46472_())) != null) {
            mgr.untrackBullet(e.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent e) {
        if (e.level.m_5776_() || e.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel sl = (ServerLevel)e.level;
        BulletLightPerLevel mgr = PER_LEVEL.get(sl.m_46472_());
        Set<UUID> set = TRACKED.get(sl.m_46472_());
        if (mgr == null || set == null || set.isEmpty()) {
            return;
        }
        int c = TICK_COUNTERS.merge((ResourceKey<Level>)sl.m_46472_(), 1, Integer::sum);
        if (c % mgr.tickInterval != 0) {
            return;
        }
        Iterator<UUID> it = set.iterator();
        while (it.hasNext()) {
            UUID id = it.next();
            Entity ent = sl.m_8791_(id);
            if (ent == null) {
                it.remove();
                mgr.untrackBullet(id);
                continue;
            }
            BlockPos pos = BlockPos.m_274561_((double)ent.m_20185_(), (double)ent.m_20186_(), (double)ent.m_20189_());
            mgr.updateBullet(id, pos);
        }
    }
}

